/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.logback.rocketchat.internal;

import ch.elexis.core.logback.rocketchat.internal.RocketchatLogMessage;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class IntegrationPostHandler {
    private final boolean attachment;
    private final ILoggingEvent eventObject;
    private final String identification;
    private final DateTimeFormatter dtf = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss.SSS");

    public IntegrationPostHandler(ILoggingEvent eventObject, String identification, boolean attachment) {
        this.eventObject = eventObject;
        this.identification = identification;
        this.attachment = attachment;
    }

    public IStatus post(URL url) throws MalformedURLException, IOException {
        Level logLevel = this.eventObject.getLevel();
        if (logLevel == null) {
            logLevel = Level.INFO;
        }
        RocketchatLogMessage rlm = new RocketchatLogMessage();
        if (this.identification != null) {
            rlm.setUsername(this.identification);
        }
        ZonedDateTime eventTimeStamp = Instant.ofEpochMilli(this.eventObject.getTimeStamp()).atZone(ZoneId.of("GMT+1"));
        StringBuilder sbHeader = new StringBuilder();
        sbHeader.append(String.valueOf(this.levelToEmoji(logLevel)) + " " + eventTimeStamp.toLocalDateTime().format(this.dtf));
        sbHeader.append(" _" + this.eventObject.getLoggerName() + "_\n");
        String sbHeaderString = sbHeader.toString();
        String exception = this.parseException(this.eventObject);
        if (this.attachment) {
            rlm.setText(sbHeaderString);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("color", this.levelToColor(logLevel));
            params.put("text", this.eventObject.getFormattedMessage());
            if (exception != null) {
                params.put("text", String.valueOf(this.eventObject.getFormattedMessage()) + exception);
            }
            rlm.setAttachments(params);
        } else {
            StringBuilder sbBody = new StringBuilder();
            sbBody.append(this.levelToEmoji(logLevel));
            sbBody.append(this.eventObject.getFormattedMessage());
            if (exception != null) {
                sbBody.append("\n" + exception);
            }
            rlm.setText(sbHeader + sbBody.toString());
        }
        String jsonMessage = new Gson().toJson((Object)rlm);
        return this.send(jsonMessage.getBytes(), url);
    }

    private String parseException(ILoggingEvent eventObject2) {
        if (this.eventObject.getThrowableProxy() != null) {
            StringBuilder sbException = new StringBuilder();
            IThrowableProxy throwableProxy = this.eventObject.getThrowableProxy();
            IThrowableProxy cause = throwableProxy.getCause();
            sbException.append("```\n");
            StackTraceElementProxy[] st = throwableProxy.getStackTraceElementProxyArray();
            int j = 0;
            while (j < st.length) {
                StackTraceElementProxy stackTraceElementProxy = st[j];
                StackTraceElement stackTraceElement = stackTraceElementProxy.getStackTraceElement();
                if (j > 0) {
                    sbException.append(" at ");
                }
                sbException.append(stackTraceElement + "\n");
                if (j == 3) break;
                ++j;
            }
            if (cause != null) {
                sbException.append("Caused by: " + cause.getMessage() + "\n");
                StackTraceElementProxy[] causeStackTraceElement = cause.getStackTraceElementProxyArray();
                if (causeStackTraceElement != null && causeStackTraceElement.length > 0) {
                    sbException.append(" at " + causeStackTraceElement[0].getStackTraceElement() + "\n");
                }
            }
            sbException.append("```");
            return sbException.toString();
        }
        return null;
    }

    private Object levelToColor(Level logLevel) {
        switch (logLevel.levelInt) {
            case 40000: {
                return "#FF0000";
            }
            case 30000: {
                return "#FFDB00";
            }
            case 20000: {
                return "#0000FF";
            }
        }
        return "#00FF00";
    }

    private String levelToEmoji(Level logLevel) {
        switch (logLevel.levelInt) {
            case 40000: {
                return ":stop_sign:";
            }
            case 30000: {
                return ":warning:";
            }
        }
        return "";
    }

    private IStatus send(byte[] postDataBytes, URL url) throws MalformedURLException, IOException {
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("POST");
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setUseCaches(false);
        con.setConnectTimeout(2000);
        con.setReadTimeout(5000);
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
        con.getOutputStream().write(postDataBytes);
        int responseCode = con.getResponseCode();
        if (responseCode == 200) {
            return Status.OK_STATUS;
        }
        return new Status(4, "ch.elexis.core.logback.rocketchat", "Error sending, with response code: " + responseCode);
    }
}

