/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.compress;

import ch.rgw.compress.GLZ;
import ch.rgw.compress.HuffmanInputStream;
import ch.rgw.tools.BinConverter;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.bzip2.CBZip2InputStream;
import org.apache.commons.compress.bzip2.CBZip2OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompEx {
    public static final Logger log = LoggerFactory.getLogger(CompEx.class);
    public static final int NONE = 0;
    public static final int GLZ = 0x20000000;
    public static final int RLL = 0x40000000;
    public static final int HUFF = 0x60000000;
    public static final int BZIP2 = Integer.MIN_VALUE;
    public static final int ZIP = -1610612736;

    public static final byte[] Compress(String in, int mode) {
        if (StringTool.isNothing(in)) {
            return null;
        }
        try {
            return CompEx.Compress(in.getBytes(StringTool.getDefaultCharset()), mode);
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return null;
        }
    }

    public static final byte[] Compress(byte[] in, int mode) {
        if (in == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(in);
        return CompEx.Compress(bais, mode);
    }

    public static final byte[] Compress(InputStream in, int mode) {
        try {
            switch (mode) {
                case 0x20000000: {
                    return CompEx.CompressGLZ(in);
                }
                case -2147483648: {
                    return CompEx.CompressBZ2(in);
                }
                case -1610612736: {
                    return CompEx.CompressZIP(in);
                }
            }
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
        }
        return null;
    }

    public static byte[] CompressGLZ(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4];
        baos.write(buf);
        GLZ glz = new GLZ();
        long total = glz.compress(in, baos);
        byte[] ret = baos.toByteArray();
        total &= 0x1FFFFFFFL;
        BinConverter.intToByteArray((int)(total |= 0x20000000L), ret, 0);
        return ret;
    }

    public static byte[] CompressBZ2(InputStream in) throws Exception {
        int l;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[8192];
        baos.write(buf, 0, 4);
        CBZip2OutputStream bzo = new CBZip2OutputStream(baos);
        int total = 0;
        while ((l = in.read(buf, 0, buf.length)) != -1) {
            bzo.write(buf, 0, l);
            total += l;
        }
        bzo.close();
        byte[] ret = baos.toByteArray();
        total &= 0x1FFFFFFF;
        BinConverter.intToByteArray(total |= Integer.MIN_VALUE, ret, 0);
        return ret;
    }

    public static byte[] CompressZIP(InputStream in) throws Exception {
        int l;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[8192];
        baos.write(buf, 0, 4);
        ZipOutputStream zo = new ZipOutputStream(baos);
        zo.putNextEntry(new ZipEntry("Data"));
        long total = 0L;
        while ((l = in.read(buf, 0, buf.length)) != -1) {
            zo.write(buf, 0, l);
            total += (long)l;
        }
        zo.close();
        byte[] ret = baos.toByteArray();
        total &= 0x1FFFFFFFL;
        BinConverter.intToByteArray((int)(total |= 0xFFFFFFFFA0000000L), ret, 0);
        return ret;
    }

    public static byte[] expand(byte[] in) {
        if (in == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(in);
        return CompEx.expand(bais);
    }

    public static byte[] expand(InputStream in) {
        byte[] siz;
        block13: {
            siz = new byte[4];
            int read = in.read(siz);
            if (read != -1) break block13;
            return null;
        }
        try {
            long size = BinConverter.byteArrayToInt(siz, 0);
            long typ = size & 0xFFFFFFFFE0000000L;
            if ((size &= 0x1FFFFFFFL) > 100000000L) {
                log.warn("Given InputStream exceeds 100 MB please check DB");
                String empty = "... Text nicht lesbar. \nBitte Datenbankeintrag pr\u00fcfen!";
                return empty.getBytes();
            }
            byte[] ret = new byte[(int)size];
            switch ((int)typ) {
                case -2147483648: {
                    CBZip2InputStream bzi = new CBZip2InputStream(in);
                    int off = 0;
                    int l = 0;
                    while ((l = bzi.read(ret, off, ret.length - off)) > 0) {
                        off += l;
                    }
                    bzi.close();
                    in.close();
                    return ret;
                }
                case 0x20000000: {
                    GLZ glz = new GLZ();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    glz.expand(in, baos);
                    return baos.toByteArray();
                }
                case 0x60000000: {
                    HuffmanInputStream hin = new HuffmanInputStream(in);
                    int off = 0;
                    int l = 0;
                    while ((l = hin.read(ret, off, ret.length - off)) > 0) {
                        off += l;
                    }
                    hin.close();
                    return ret;
                }
                case -1610612736: {
                    ZipInputStream zi = new ZipInputStream(in);
                    zi.getNextEntry();
                    int off = 0;
                    int l = 0;
                    while ((l = zi.read(ret, off, ret.length - off)) > 0) {
                        off += l;
                    }
                    zi.close();
                    return ret;
                }
            }
            throw new Exception("Invalid compress format");
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return null;
        }
    }
}

