/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.swt.internal;

import com.equo.chromium.swt.internal.Engine;
import com.equo.chromium.swt.internal.Eval;
import com.equo.chromium.wl.IBrowser;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.cef.CefClientSwt;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefMessageRouter;
import org.cef.handler.CefLifeSpanHandlerAdapter;
import org.eclipse.swt.SWTException;

public final class Windowless
implements IBrowser {
    private CefClientSwt clientHandler;
    private CefMessageRouter router;
    private CefBrowser browser;
    private CompletableFuture<Boolean> created = new CompletableFuture();

    public Windowless(String url) {
        Engine.initCEF();
        this.createClient();
        this.browser = this.clientHandler.createBrowser(url, true, false, null);
        this.browser.createImmediately();
    }

    private void createClient() {
        this.clientHandler = (CefClientSwt)Engine.createClient();
        this.clientHandler.addLifeSpanHandler(new CefLifeSpanHandlerAdapter(){

            @Override
            public void onAfterCreated(CefBrowser browser) {
                Windowless.this.created.complete(true);
            }
        });
        this.router = Eval.createRouter();
        this.clientHandler.addMessageRouter(this.router);
    }

    @Override
    public boolean setUrl(String url) {
        this.created.thenRun(() -> this.browser.loadURL(url));
        return true;
    }

    @Override
    public Object evaluate(String script) {
        try {
            return Eval.eval(script, this.browser.getURL(), this.browser, this.router, this.created);
        }
        catch (InterruptedException e) {
            throw new SWTException("Script that was evaluated failed");
        }
        catch (ExecutionException e) {
            throw (SWTException)e.getCause();
        }
    }

    @Override
    public boolean close() {
        this.browser.setCloseAllowed();
        this.browser.close(true);
        this.clientHandler.removeMessageRouter(this.router);
        this.router.dispose();
        this.clientHandler.dispose();
        return true;
    }
}

