/*
 * Decompiled with CFR 0.152.
 */
package waelti.statistics.actions;

import ch.elexis.core.ui.util.SWTHelper;
import java.io.IOException;
import java.util.Calendar;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import waelti.statistics.export.CSVWriter;
import waelti.statistics.views.OutputView;

public class ExportAction
extends Action {
    private OutputView view;
    private static String extension = "csv";

    public ExportAction() {
        this.setText("Export");
        this.setToolTipText("Exportiert die Auswertung als CSV.");
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"Waelti.Statistics", (String)"icons/page_excel.png"));
    }

    public ExportAction(OutputView view) {
        this();
        this.view = view;
    }

    public void run() {
        FileDialog chooser = new FileDialog(this.view.getSite().getShell(), 8192);
        chooser.setFilterExtensions(new String[]{extension});
        String defaultName = this.getNameSuggestion();
        chooser.setFileName(defaultName);
        String fileName = chooser.open();
        if (fileName != null) {
            this.saveFile(fileName);
        }
    }

    private void saveFile(String fileName) {
        String name = fileName + "." + extension;
        try {
            CSVWriter.write(this.view.getQuery(), name);
        }
        catch (IOException iOException) {
            SWTHelper.showError((String)"Exportfehler", (String)"Beim Erstellen der CSV-Datei ist ein Fehler aufgetreten.");
        }
    }

    private String getNameSuggestion() {
        Object name = this.view.getQuery().getTitle().toLowerCase();
        name = (String)name + " ";
        name = (String)name + Calendar.getInstance().get(5);
        name = (String)name + " ";
        name = (String)name + (Calendar.getInstance().get(2) + 1);
        name = (String)name + " ";
        name = (String)name + Calendar.getInstance().get(1);
        return name;
    }
}

