/*
 * Decompiled with CFR 0.152.
 */
package waelti.statistics.export;

import ch.rgw.tools.Money;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Locale;
import waelti.statistics.queries.AbstractQuery;
import waelti.statistics.queries.ResultMatrix;

public class CSVWriter {
    private static String delimiter = ";";

    public static File write(AbstractQuery query, String file) throws IOException {
        return CSVWriter.write(query, new File(file));
    }

    public static File write(AbstractQuery query, File file) throws IOException {
        ResultMatrix matrix = query.getMatrix();
        return CSVWriter.writer(matrix, file);
    }

    public static File writer(ResultMatrix matrix, File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "ISO-8859-1");){
            try {
                CSVWriter.writeHeading(osw, matrix.getHeadings());
                for (Object[] objects : matrix) {
                    CSVWriter.writeRow(osw, objects);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                osw.close();
            }
        }
        return file;
    }

    private static void writeHeading(OutputStreamWriter writer, List<String> headings) throws IOException {
        Object[] objects = headings.toArray();
        CSVWriter.writeRow(writer, objects);
    }

    private static void writeRow(OutputStreamWriter writer, Object[] objects) throws IOException {
        StringBuilder buf = new StringBuilder();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof Number) {
                if (obj instanceof Money) {
                    buf.append(obj.toString());
                } else {
                    buf.append(String.format(Locale.US, "%.2f", obj));
                }
            } else {
                buf.append(obj.toString());
            }
            buf.append(delimiter);
            ++n2;
        }
        buf.deleteCharAt(buf.length() - 1);
        buf.append(System.lineSeparator());
        writer.write(buf.toString());
    }
}

