/*
 * Decompiled with CFR 0.152.
 */
package waelti.statistics.queries;

import java.util.Calendar;
import waelti.statistics.queries.AbstractQuery;
import waelti.statistics.queries.QueryUtil;
import waelti.statistics.queries.SetDataException;
import waelti.statistics.queries.annotations.GetProperty;
import waelti.statistics.queries.annotations.SetProperty;

public abstract class AbstractTimeSeries
extends AbstractQuery {
    private Calendar startDate = null;
    private Calendar endDate = null;

    public AbstractTimeSeries(String name) {
        super(name);
        this.initData();
    }

    protected void initData() {
        this.setStartDate(Calendar.getInstance());
        this.getStartDate().set(this.getStartDate().get(1), 0, 1);
        this.setEndDate(Calendar.getInstance());
        this.getEndDate().set(this.getEndDate().get(1), 11, 31);
    }

    public void setStartDate(Calendar startDate) {
        this.startDate = startDate;
    }

    public Calendar getStartDate() {
        return this.startDate;
    }

    public void setEndDate(Calendar endDate) {
        this.endDate = endDate;
    }

    public Calendar getEndDate() {
        return this.endDate;
    }

    @GetProperty(value="Anfangsdatum", index=0)
    public String metaGetStartDate() {
        return QueryUtil.convertFromCalendar(this.getStartDate());
    }

    @SetProperty(value="Anfangsdatum", index=0)
    public void metaSetStartDate(String startDate) throws SetDataException {
        Calendar cal;
        try {
            cal = QueryUtil.convertToCalendar(startDate);
            cal.get(5);
            cal.get(2);
            cal.get(1);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SetDataException("Anfangsdatum nicht im richtigen Format. Bitte in folgendem Format angeben: dd.mm.yyy");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SetDataException("Das Anfangsdatum ist kein valides Datum.");
        }
        this.setStartDate(cal);
    }

    @GetProperty(value="Enddatum", index=1)
    public String metaGetEndDate() {
        return QueryUtil.convertFromCalendar(this.getEndDate());
    }

    @SetProperty(value="Enddatum", index=1)
    public void metaSetEndDate(String endDate) throws SetDataException {
        Calendar cal;
        try {
            cal = QueryUtil.convertToCalendar(endDate);
            cal.get(5);
            cal.get(2);
            cal.get(1);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SetDataException("Enddatum nicht im richtigen Format. Bitte in folgendem Format angeben: dd.mm.yyyy");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SetDataException("Das Enddatum ist kein g\u00fcltiges Datum. Bitte geben Sie ein g\u00fcltiges Datum ein.");
        }
        if (cal.compareTo(this.getStartDate()) < 0) {
            throw new SetDataException("Enddatum vor Anfangsdatum. Bitte \u00e4ndern Sie das Start- oder Enddatum der Auswertung.");
        }
        this.setEndDate(cal);
    }
}

