/*
 * Decompiled with CFR 0.152.
 */
package waelti.statistics.actions;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.BackgroundJob;
import ch.elexis.core.ui.util.SWTHelper;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.layout.GridData;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import waelti.statistics.queries.AbstractQuery;
import waelti.statistics.views.OptionPanel;
import waelti.statistics.views.OutputView;
import waelti.statistics.views.QueryInputDialog;
import waelti.statistics.views.ResultTable;

public class NewQueryAction
extends Action
implements BackgroundJob.BackgroundJobListener {
    private OutputView view;
    private AbstractQuery configuredQuery;

    public NewQueryAction() {
        this.setText("neue Auswertung");
        this.setToolTipText("Startet eine neue Auswertung.");
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"Waelti.Statistics", (String)"icons/database_go.png"));
    }

    public NewQueryAction(OutputView view) {
        this();
        this.view = view;
    }

    public void run() {
        this.getView().setButtonsEnabled(false);
        this.getInput();
        if (this.configuredQuery == null) {
            this.getView().setButtonsEnabled(true);
        } else {
            this.configuredQuery.addListener(this);
            this.view.setQuery(this.configuredQuery);
            this.createQueryOption();
            this.createContentAndTable();
            this.view.setHeader(this.configuredQuery.getTitle());
        }
    }

    private void createQueryOption() {
        OptionPanel panel = new OptionPanel(this.view.getParent(), UiDesk.getColor((String)"weiss"));
        panel.updateContent(this.configuredQuery);
        panel.setLayoutData(SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.view.setQueryOptions(panel);
    }

    private void createContentAndTable() {
        if (this.getView().getResultView() != null) {
            this.getView().getResultView().dispose();
        }
        ResultTable table = new ResultTable(this.getView().getParent(), 2048, this.configuredQuery);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        table.setLayoutData(data);
        this.getView().setResultView(table);
        this.configuredQuery.schedule();
        this.getView().getParent().layout();
    }

    protected void getInput() {
        QueryInputDialog dialog = new QueryInputDialog(this.view.getSite().getShell(), this);
        if (dialog.open() != 0) {
            this.configuredQuery = null;
        }
    }

    public void jobFinished(BackgroundJob j) {
        this.getView().setButtonsEnabled(true);
        this.getView().getResultView().createTable(this.configuredQuery);
    }

    public void setConfiguredQuery(AbstractQuery configuredQuery) {
        this.configuredQuery = configuredQuery;
    }

    protected OutputView getView() {
        return this.view;
    }

    protected AbstractQuery getConfiguredQuery() {
        return this.configuredQuery;
    }
}

