/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.messwerte.preferences;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Labor;
import ch.elexis.data.Query;
import ch.rgw.tools.StringTool;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class MesswertePreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.iatrix.messwerte.preferences.MesswertePreferences";
    private static final int VISIBLE_NUMBER_OF_LABORS = 5;
    private ListViewer ownLaborsList;
    private Spinner spinnerNoCol;

    public MesswertePreferences() {
    }

    public MesswertePreferences(String title) {
        super(title);
    }

    public MesswertePreferences(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        Composite mainArea = new Composite(parent, 0);
        mainArea.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.topMargin = 0;
        layout.bottomMargin = 0;
        mainArea.setLayout((Layout)layout);
        Text infoText = new Text(mainArea, 74);
        infoText.setLayoutData((Object)SWTHelper.getFillTableWrapData((int)2, (boolean)true, (int)1, (boolean)false));
        infoText.setText("Bitte w\u00e4hlen Sie die Labors aus, f\u00fcr welche Sie die Werte in der Praxis selber ermitteln.");
        Label label = new Label(mainArea, 0);
        label.setText("Praxislabors:");
        this.ownLaborsList = new ListViewer(mainArea, 770);
        org.eclipse.swt.widgets.List list = this.ownLaborsList.getList();
        TableWrapData twd = SWTHelper.getFillTableWrapData((int)1, (boolean)true, (int)1, (boolean)false);
        twd.heightHint = 5 * list.getItemHeight();
        list.setLayoutData((Object)twd);
        this.ownLaborsList.setContentProvider((IContentProvider)new LaborsListContentProvider());
        this.ownLaborsList.setLabelProvider((IBaseLabelProvider)new LaborsListLabelProvider());
        this.ownLaborsList.setInput((Object)this);
        Label lblNoCols = new Label(mainArea, 0);
        lblNoCols.setText("Spalten pro Seite:");
        this.spinnerNoCol = new Spinner(mainArea, 2048);
        this.spinnerNoCol.setPageIncrement(1);
        this.spinnerNoCol.setMaximum(10);
        this.spinnerNoCol.setMinimum(1);
        this.spinnerNoCol.setSelection(7);
        this.loadFromConfig();
        return mainArea;
    }

    private void loadFromConfig() {
        String[] laborIds;
        ArrayList<Labor> labors = new ArrayList<Labor>();
        String localLabors = ConfigServiceHolder.getGlobal((String)"org.iatrix.messwerte/local_labors", (String)"");
        String[] stringArray = laborIds = localLabors.split("\\s*,\\s*");
        int n = laborIds.length;
        int n2 = 0;
        while (n2 < n) {
            Labor labor;
            String laborId = stringArray[n2];
            if (!StringTool.isNothing((Object)laborId) && (labor = Labor.load((String)laborId)) != null && labor.exists()) {
                labors.add(labor);
            }
            ++n2;
        }
        StructuredSelection selection = new StructuredSelection(labors);
        this.ownLaborsList.setSelection((ISelection)selection);
        this.spinnerNoCol.setSelection(CoreHub.localCfg.get("org.iatrix.messwerte/messwerte_view_number_of_columns", new Integer(7).intValue()));
    }

    private void storeToConfig() {
        ArrayList<String> selectedLaborsIds = new ArrayList<String>();
        IStructuredSelection selection = (IStructuredSelection)this.ownLaborsList.getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof Labor) {
                Labor labor = (Labor)element;
                selectedLaborsIds.add(labor.getId());
            }
            ++n2;
        }
        String cfgValue = StringTool.join(selectedLaborsIds, (String)",");
        ConfigServiceHolder.setGlobal((String)"org.iatrix.messwerte/local_labors", (String)cfgValue);
        if (this.spinnerNoCol.getSelection() != CoreHub.localCfg.get("org.iatrix.messwerte/messwerte_view_number_of_columns", 7)) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Information", (String)"Bitte schliessen Sie den Messwerte Iatrix View \n und \u00f6ffnen Sie Ihn dann erneut um die \u00c4nderungen wirksam zu machen.");
            CoreHub.localCfg.set("org.iatrix.messwerte/messwerte_view_number_of_columns", this.spinnerNoCol.getSelection());
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        StructuredSelection selection = new StructuredSelection();
        this.ownLaborsList.setSelection((ISelection)selection);
        this.spinnerNoCol.setSelection(7);
        super.performDefaults();
    }

    public boolean performOk() {
        this.storeToConfig();
        return true;
    }

    class LaborsListContentProvider
    implements IStructuredContentProvider {
        LaborsListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Query query = new Query(Labor.class);
            query.orderBy(false, new String[]{"Name"});
            List labors = query.execute();
            if (labors != null) {
                return labors.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class LaborsListLabelProvider
    extends LabelProvider {
        LaborsListLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Labor) {
                Labor labor = (Labor)element;
                return labor.getLabel();
            }
            return super.getText(element);
        }
    }
}

