/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.bestellung.rose;

import at.medevit.elexis.hin.auth.core.IHinAuthService;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.preferences.ConfigServicePreferenceStore;
import ch.elexis.core.ui.preferences.inputs.KontaktFieldEditor;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.iatrix.bestellung.rose.AdditionalClientNumber;
import org.iatrix.bestellung.rose.HinAuthServiceHolder;
import org.iatrix.bestellung.rose.RoseClientNumberComposite;

public class RosePreferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Composite additionalClientNumbers;

    public RosePreferences() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.GLOBAL));
        this.setDescription("Einstellung zur Bestellung bei der Apotheke zur Rose");
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new StringFieldEditor("org.iatrix.bestellung.rose/global_client_number", "Kundennummer", this.getFieldEditorParent()));
        Optional<IHinAuthService> hinAuthService = HinAuthServiceHolder.get();
        if (!hinAuthService.isPresent()) {
            this.addField((FieldEditor)new StringFieldEditor("org.iatrix.bestellung.rose/asas_host", "HIN-Client Adresse", this.getFieldEditorParent()));
            this.addField((FieldEditor)new StringFieldEditor("org.iatrix.bestellung.rose/asas_port", "HIN-Client Port", this.getFieldEditorParent()));
        }
        this.addField((FieldEditor)new KontaktFieldEditor(new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.GLOBAL), "org.iatrix.bestellung.rose/supplier", "Lieferant", this.getFieldEditorParent()));
        InputStream properties = ((Object)((Object)this)).getClass().getResourceAsStream("/rsc/id.properties");
        if (properties == null) {
            this.addField((FieldEditor)new StringFieldEditor("org.iatrix.bestellung.rose/client_id_prod", "Client ID", this.getFieldEditorParent()));
            this.addField((FieldEditor)new StringFieldEditor("org.iatrix.bestellung.rose/client_secret_prod", "Client Secret", this.getFieldEditorParent()));
        }
    }

    protected Control createContents(Composite parent) {
        final Control ret = super.createContents(parent);
        this.additionalClientNumbers = new Composite((Composite)ret, 2048);
        this.additionalClientNumbers.setLayout((Layout)new GridLayout());
        this.additionalClientNumbers.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Button btn = new Button(this.additionalClientNumbers, 8);
        btn.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        btn.setText("Zus\u00e4tzliche Kundennummer");
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RoseClientNumberComposite comp = new RoseClientNumberComposite(RosePreferences.this.additionalClientNumbers, 2048);
                comp.setClientNumber(new AdditionalClientNumber(""));
                comp.setLayoutData(new GridData(4, 0x1000000, true, false));
                ((Composite)ret).layout(true, true);
            }
        });
        List<AdditionalClientNumber> additionalClients = AdditionalClientNumber.getConfigured();
        for (AdditionalClientNumber additionalClientNumber : additionalClients) {
            RoseClientNumberComposite comp = new RoseClientNumberComposite(this.additionalClientNumbers, 2048);
            comp.setLayoutData(new GridData(4, 0x1000000, true, false));
            comp.setClientNumber(additionalClientNumber);
        }
        return ret;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        if (super.performOk()) {
            this.saveAdditionalClientNumbers();
            CoreHub.globalCfg.flush();
            return true;
        }
        return false;
    }

    private void saveAdditionalClientNumbers() {
        ArrayList<AdditionalClientNumber> toSave = new ArrayList<AdditionalClientNumber>();
        Control[] controlArray = this.additionalClientNumbers.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof RoseClientNumberComposite && !control.isDisposed()) {
                RoseClientNumberComposite composite = (RoseClientNumberComposite)control;
                composite.getClientNumber().ifPresent(ac -> {
                    boolean bl = toSave.add((AdditionalClientNumber)ac);
                });
            }
            ++n2;
        }
        String prefString = AdditionalClientNumber.toString(toSave);
        this.getPreferenceStore().putValue("org.iatrix.bestellung.rose/additional_client_numbers", prefString);
    }
}

