/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.bestellung.rose.service;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IOrder;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.OrderEntryState;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.exchange.ArticleUtil;
import ch.elexis.core.ui.exchange.XChangeException;
import ch.elexis.core.ui.views.BestellView;
import gs1.ecom.ecom_common.xsd.EcomEntityIdentificationType;
import gs1.ecom.ecom_common.xsd.OrderLogisticalInformationType;
import gs1.ecom.ecom_common.xsd.OrderTypeCodeType;
import gs1.ecom.ecom_common.xsd.TransactionalPartyType;
import gs1.ecom.ecom_common.xsd.TransactionalTradeItemType;
import gs1.ecom.order.xsd.ObjectFactory;
import gs1.ecom.order.xsd.OrderLineItemType;
import gs1.ecom.order.xsd.OrderMessageType;
import gs1.ecom.order.xsd.OrderType;
import gs1.shared.shared_common.xsd.AdditionalPartyIdentificationType;
import gs1.shared.shared_common.xsd.AdditionalTradeItemIdentificationType;
import gs1.shared.shared_common.xsd.Description1000Type;
import gs1.shared.shared_common.xsd.DocumentStatusEnumerationType;
import gs1.shared.shared_common.xsd.ExtensionType;
import gs1.shared.shared_common.xsd.QuantityType;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.Marshaller;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.swt.widgets.Display;
import org.iatrix.bestellung.rose.AdditionalClientNumber;
import org.iatrix.bestellung.rose.AdditionalClientNumberSelectorDialog;
import org.unece.cefact.namespaces.standardbusinessdocumentheader.DocumentIdentification;
import org.unece.cefact.namespaces.standardbusinessdocumentheader.Partner;
import org.unece.cefact.namespaces.standardbusinessdocumentheader.PartnerIdentification;
import org.unece.cefact.namespaces.standardbusinessdocumentheader.StandardBusinessDocumentHeader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Gs1OrderXmlGenerator {
    private List<IOrderEntry> exportedEntries = new ArrayList<IOrderEntry>();

    public String createOrderXml(IOrder order) throws XChangeException {
        if (order == null || order.getEntries().isEmpty()) {
            throw new XChangeException("The order is empty.");
        }
        this.exportedEntries.clear();
        String supplier = ConfigServiceHolder.getGlobal((String)"org.iatrix.bestellung.rose/supplier", null);
        String selDialogTitle = Messages.OrderSupplierNotDefined;
        IContact roseSupplier = BestellView.resolveDefaultSupplier((String)supplier, (String)selDialogTitle);
        if (roseSupplier == null) {
            throw new XChangeException(Messages.OrderSupplierNotDefined);
        }
        try {
            ObjectFactory factory = new ObjectFactory();
            StandardBusinessDocumentHeader sbdh = new StandardBusinessDocumentHeader();
            sbdh.setHeaderVersion("1.0");
            Partner sender = new Partner();
            PartnerIdentification senderId = new PartnerIdentification();
            senderId.setAuthority("PartnerName");
            senderId.setValue("Elexis");
            sender.setIdentifier(senderId);
            sbdh.getSender().add(sender);
            Partner receiver = new Partner();
            PartnerIdentification receiverId = new PartnerIdentification();
            receiverId.setAuthority("ZurRose");
            receiverId.setValue("ZurRose");
            receiver.setIdentifier(receiverId);
            sbdh.getReceiver().add(receiver);
            DocumentIdentification docId = new DocumentIdentification();
            docId.setStandard("GS1");
            docId.setTypeVersion("3.4.1");
            docId.setInstanceIdentifier(order.getId());
            docId.setType("Order");
            docId.setMultipleType(false);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS");
            String formattedDateTime = LocalDateTime.now().format(formatter);
            XMLGregorianCalendar creationTimestamp = DatatypeFactory.newInstance().newXMLGregorianCalendar(formattedDateTime);
            docId.setCreationDateAndTime(creationTimestamp);
            sbdh.setDocumentIdentification(docId);
            OrderMessageType orderMessageType = factory.createOrderMessageType();
            orderMessageType.setStandardBusinessDocumentHeader(sbdh);
            OrderType orderType = factory.createOrderType();
            EcomEntityIdentificationType entityId = new EcomEntityIdentificationType();
            boolean hasOrderedEntries = order.getEntries().stream().anyMatch(e -> e.getState() != null && (e.getState().equals((Object)OrderEntryState.ORDERED) || e.getState().equals((Object)OrderEntryState.PARTIAL_DELIVER)));
            if (hasOrderedEntries) {
                entityId.setEntityIdentification(UUID.randomUUID().toString());
            } else {
                entityId.setEntityIdentification(UUID.nameUUIDFromBytes(order.getId().getBytes()).toString());
            }
            orderType.setOrderIdentification(entityId);
            OrderTypeCodeType orderTypeCode = new OrderTypeCodeType();
            orderTypeCode.setValue("220");
            orderType.setOrderTypeCode(orderTypeCode);
            orderType.setCreationDateTime(creationTimestamp);
            orderType.setDocumentStatusCode(DocumentStatusEnumerationType.ORIGINAL);
            ExtensionType extensionType = new ExtensionType();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element originElement = doc.createElement("origin");
            originElement.setTextContent("Elexis");
            extensionType.getAny().add(originElement);
            orderType.setExtension(extensionType);
            Description1000Type additionalOrderInstruction = new Description1000Type();
            additionalOrderInstruction.setLanguageCode("en");
            additionalOrderInstruction.setValue("ROWA");
            orderType.getAdditionalOrderInstruction().add(additionalOrderInstruction);
            String buyerNo = this.getClientNumber();
            TransactionalPartyType buyer = new TransactionalPartyType();
            AdditionalPartyIdentificationType buyerAdditionalId = new AdditionalPartyIdentificationType();
            buyerAdditionalId.setValue(buyerNo);
            buyerAdditionalId.setAdditionalPartyIdentificationTypeCode("BUYER_ASSIGNED_IDENTIFIER_FOR_A_PARTY");
            buyer.getAdditionalPartyIdentification().add(buyerAdditionalId);
            TransactionalPartyType seller = new TransactionalPartyType();
            AdditionalPartyIdentificationType sellerAdditionalId = new AdditionalPartyIdentificationType();
            sellerAdditionalId.setValue("54183");
            sellerAdditionalId.setAdditionalPartyIdentificationTypeCode("SELLER_ASSIGNED_IDENTIFIER_FOR_A_PARTY");
            seller.getAdditionalPartyIdentification().add(sellerAdditionalId);
            orderType.setBuyer(buyer);
            orderType.setSeller(seller);
            OrderLogisticalInformationType logisticalInfo = new OrderLogisticalInformationType();
            orderType.setOrderLogisticalInformation(logisticalInfo);
            int lineNumber = 1;
            for (IOrderEntry entry : order.getEntries()) {
                String pharmacode;
                IContact artSupplier;
                if (entry.getState() != OrderEntryState.OPEN || !roseSupplier.equals(artSupplier = entry.getProvider())) continue;
                this.exportedEntries.add(entry);
                OrderLineItemType lineItem = factory.createOrderLineItemType();
                lineItem.setLineItemNumber(BigInteger.valueOf(lineNumber++));
                QuantityType requestedQuantity = new QuantityType();
                requestedQuantity.setValue(BigDecimal.valueOf(entry.getAmount()));
                lineItem.setRequestedQuantity(requestedQuantity);
                TransactionalTradeItemType tradeItem = new TransactionalTradeItemType();
                String gtin = entry.getArticle().getGtin();
                if (gtin.length() == 13) {
                    tradeItem.setGtin("0" + gtin);
                } else if (gtin.length() == 14) {
                    tradeItem.setGtin(gtin);
                } else {
                    throw new IllegalArgumentException("Invalid GTIN length: " + gtin.length());
                }
                if (entry.getArticle().getAtcCode() != null && !entry.getArticle().getAtcCode().isEmpty() && (pharmacode = ArticleUtil.getPharmaCode((IArticle)entry.getArticle())).matches("\\d{7}")) {
                    AdditionalTradeItemIdentificationType additionalTradeId = new AdditionalTradeItemIdentificationType();
                    additionalTradeId.setValue(pharmacode);
                    additionalTradeId.setAdditionalTradeItemIdentificationTypeCode("PHARMACODE_CH");
                    tradeItem.getAdditionalTradeItemIdentification().add(additionalTradeId);
                }
                lineItem.setTransactionalTradeItem(tradeItem);
                orderType.getOrderLineItem().add(lineItem);
            }
            orderMessageType.getOrder().add(orderType);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{OrderMessageType.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            JAXBElement<OrderMessageType> jaxbElement = factory.createOrderMessage(orderMessageType);
            StringWriter sw = new StringWriter();
            marshaller.marshal(jaxbElement, (Writer)sw);
            return sw.toString();
        }
        catch (Exception e2) {
            throw new XChangeException("Error when generating the order XML via JAXB: " + e2.getMessage());
        }
    }

    private String getClientNumber() {
        Object[] dialogResult;
        AdditionalClientNumberSelectorDialog dialog;
        String number = ConfigServiceHolder.getGlobal((String)"org.iatrix.bestellung.rose/global_client_number", (String)"").trim();
        if (AdditionalClientNumber.isConfigured() && (dialog = new AdditionalClientNumberSelectorDialog(Display.getDefault().getActiveShell())).open() == 0 && (dialogResult = dialog.getResult()) != null && dialogResult[0] instanceof AdditionalClientNumber) {
            number = ((AdditionalClientNumber)dialogResult[0]).getClientNumber();
        }
        return number;
    }

    public List<IOrderEntry> getExportedEntries() {
        return this.exportedEntries;
    }
}

