/*
 * Decompiled with CFR 0.152.
 */
package net.medshare.connector.viollier.handlers;

import ch.elexis.core.constants.Elexis;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.data.Anschrift;
import ch.elexis.data.Fall;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import net.medshare.connector.viollier.Messages;
import net.medshare.connector.viollier.data.ViollierConnectorSettings;
import net.medshare.connector.viollier.ses.PortalCookieService;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateOrderHandler
extends AbstractHandler {
    private static Logger log = LoggerFactory.getLogger(CreateOrderHandler.class);
    private ViollierConnectorSettings mySettings;
    private String httpsUrl;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String cookie = "";
        String vorname = "";
        String name = "";
        String geburtsdatum = "";
        String gender = "";
        String address = "";
        String plz = "";
        String ort = "";
        String land = "";
        String socialSecurityNumber = "";
        String insuranceCardNumber = "";
        Patient patient = ElexisEventDispatcher.getSelectedPatient();
        if (patient == null) {
            log.warn("No patient selected - exit CreateOrderHandler execution");
            MessageDialog.openError((Shell)new Shell(), (String)Messages.Handler_errorTitleNoPatientSelected, (String)Messages.Handler_errorMessageNoPatientSelected);
            return null;
        }
        vorname = patient.getVorname();
        name = patient.getName();
        geburtsdatum = this.convertDate(patient.getGeburtsdatum());
        gender = this.parseGender(patient);
        Anschrift tempAdr = patient.getAnschrift();
        address = tempAdr.getStrasse();
        plz = tempAdr.getPlz();
        ort = tempAdr.getOrt();
        land = tempAdr.getLand();
        socialSecurityNumber = this.getSocialSecuritNumber(patient);
        insuranceCardNumber = this.getInsuranceCardNumber(patient);
        this.mySettings = new ViollierConnectorSettings((Mandant)ElexisEventDispatcher.getSelected(Mandant.class));
        this.httpsUrl = this.mySettings.getGlobalLoginUrl();
        try {
            cookie = new PortalCookieService().getCookie();
        }
        catch (IOException e) {
            log.error("Error getting cookie", (Throwable)e);
            MessageDialog.openError((Shell)new Shell(), (String)Messages.Handler_errorTitleGetCookie, (String)(Messages.Handler_errorMessageGetCookie + e.getMessage()));
        }
        catch (ElexisException e) {
            log.error("No password/user defined", (Throwable)e);
            MessageDialog.openError((Shell)new Shell(), (String)Messages.Handler_errorTitleGetCookie, (String)e.getMessage());
        }
        this.httpsUrl = String.valueOf(this.httpsUrl) + "&RCSession=" + cookie;
        try {
            this.httpsUrl = String.valueOf(this.httpsUrl) + "&appPath=" + URLEncoder.encode("/orderit/createOrderFromGP?", "UTF-8");
            this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("firstname=" + vorname, "UTF-8");
            this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&surname=" + name, "UTF-8");
            this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&dateOfBirth=" + geburtsdatum, "UTF-8");
            this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&gender=" + gender, "UTF-8");
            this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&address=" + address, "UTF-8");
            this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&zip=" + plz, "UTF-8");
            this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&city=" + ort, "UTF-8");
            this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&country=" + land, "UTF-8");
            this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&patientReference=" + patient.getPatCode(), "UTF-8");
            if (StringUtils.isNotBlank((CharSequence)patient.get("NatelNr"))) {
                this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&mobileNumber=" + patient.get("NatelNr"), "UTF-8");
            }
            if (StringUtils.isNotBlank((CharSequence)socialSecurityNumber)) {
                this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&socialSecurityNumber=" + socialSecurityNumber, "UTF-8");
            }
            if (StringUtils.isNotBlank((CharSequence)insuranceCardNumber)) {
                this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&insuranceCardNumber=" + insuranceCardNumber, "UTF-8");
            }
            this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&senderName=elexis.info", "UTF-8");
            this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("&senderSoftware=" + this.getSenderSoftware(), "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            log.error("Enoding not supported", (Throwable)e1);
        }
        try {
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            IWebBrowser externalBrowser = browserSupport.getExternalBrowser();
            externalBrowser.openURL(new URI(this.httpsUrl).toURL());
        }
        catch (Exception e) {
            log.error("Error openen url [{}]: ", (Object)this.httpsUrl, (Object)e);
        }
        return null;
    }

    private String getSenderSoftware() {
        StringBuilder sb = new StringBuilder();
        if ("Elexis Core".contains(" ")) {
            sb.append("Elexis Core".split(" ")[0]);
        } else {
            sb.append("Elexis Core");
        }
        sb.append(" ");
        String[] parts = Elexis.VERSION.split("\\.");
        if (parts.length > 3) {
            sb.append(parts[0]).append(".").append(parts[1]).append(".").append(parts[2]);
        } else {
            sb.append(Elexis.VERSION);
        }
        return sb.toString();
    }

    private String getInsuranceCardNumber(Patient patient) {
        String ret = "";
        Fall[] fallArray = patient.getFaelle();
        int n = fallArray.length;
        int n2 = 0;
        while (n2 < n) {
            Fall fall = fallArray[n2];
            if (fall.isOpen()) {
                if (StringUtils.isNotBlank((CharSequence)((String)fall.getExtInfoStoredObjectByKey((Object)"VEKANr")))) {
                    ret = fall.getRequiredString("VEKANr");
                    break;
                }
                if (StringUtils.isNotBlank((CharSequence)fall.getRequiredString("Versicherten-Nummer"))) {
                    ret = fall.getRequiredString("Versicherten-Nummer");
                    break;
                }
            }
            ++n2;
        }
        return ret;
    }

    private String getSocialSecuritNumber(Patient patient) {
        String ret = patient.getXid("www.ahv.ch/xid");
        if (StringUtils.isBlank((CharSequence)ret)) {
            Fall[] fallArray = patient.getFaelle();
            int n = fallArray.length;
            int n2 = 0;
            while (n2 < n) {
                Fall fall = fallArray[n2];
                if (fall.isOpen() && StringUtils.isNotBlank((CharSequence)fall.getRequiredString("AHV-Nummer"))) {
                    ret = fall.getRequiredString("AHV-Nummer");
                    break;
                }
                ++n2;
            }
        }
        return ret;
    }

    private String parseGender(Patient patient) {
        String sexRaw = patient.getGeschlecht();
        if (sexRaw.length() > 0) {
            if (sexRaw.equalsIgnoreCase("m")) {
                return "M";
            }
            return "F";
        }
        return "X";
    }

    private String convertDate(String gebDat) {
        if (gebDat.isEmpty()) {
            return "";
        }
        String tempDay = gebDat.substring(0, 2);
        String tempMonth = gebDat.substring(3, 5);
        String tempYear = gebDat.substring(6);
        return tempYear + "-" + tempMonth + "-" + tempDay;
    }
}

