/*
 * Decompiled with CFR 0.152.
 */
package net.medshare.connector.viollier.handlers;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.data.LabResult;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.laborimport.viollier.v2.data.KontaktOrderManagement;
import ch.elexis.laborimport.viollier.v2.data.LaborwerteOrderManagement;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import net.medshare.connector.viollier.Messages;
import net.medshare.connector.viollier.data.ViollierConnectorSettings;
import net.medshare.connector.viollier.ses.PortalCookieService;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepeatOrderHandler
extends AbstractHandler {
    private static Logger log = LoggerFactory.getLogger(RepeatOrderHandler.class);
    private ViollierConnectorSettings mySettings;
    private String httpsUrl;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String cookie = "";
        this.mySettings = new ViollierConnectorSettings((Mandant)ElexisEventDispatcher.getSelected(Mandant.class));
        this.httpsUrl = this.mySettings.getGlobalLoginUrl();
        try {
            cookie = new PortalCookieService().getCookie();
        }
        catch (IOException e) {
            log.error("Error getting cookie", (Throwable)e);
            MessageDialog.openError((Shell)new Shell(), (String)Messages.Handler_errorTitleGetCookie, (String)(Messages.Handler_errorMessageGetCookie + e.getMessage()));
        }
        catch (ElexisException e) {
            log.error("No password/user defined", (Throwable)e);
            MessageDialog.openError((Shell)new Shell(), (String)Messages.Handler_errorTitleGetCookie, (String)e.getMessage());
        }
        this.httpsUrl = String.valueOf(this.httpsUrl) + "&RCSession=" + cookie;
        try {
            this.httpsUrl = String.valueOf(this.httpsUrl) + "&appPath=" + URLEncoder.encode("/orderit/createOrderFromConsultIT?app=LAB400CI&", "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            log.error("Enoding not supported", (Throwable)e1);
        }
        Patient patient = ElexisEventDispatcher.getSelectedPatient();
        if (patient == null) {
            log.warn("No patient selected - exit execution of RepeatOrderHandler");
            MessageDialog.openError((Shell)new Shell(), (String)Messages.Handler_errorTitleNoPatientSelected, (String)Messages.Handler_errorMessageNoPatientSelected);
            return null;
        }
        PersistentObject obj = (PersistentObject)ElexisEventDispatcher.getSelected(LabResult.class);
        String labResultId = null;
        if (obj != null) {
            labResultId = ((LabResult)obj).getId();
        }
        if (labResultId == null || labResultId.isEmpty()) {
            log.warn("No LabResult-ID - exit execution of RepeatOrderHandler");
            MessageDialog.openError((Shell)new Shell(), (String)Messages.Handler_errorTitleNoLabResultSelected, (String)Messages.Handler_errorMessageNoLabResultSelected);
            return null;
        }
        String orderId = LaborwerteOrderManagement.findOrderId((String)labResultId);
        String orderNr = KontaktOrderManagement.load((String)orderId).get("ORDER_NR");
        if (orderNr == null || orderNr.isEmpty()) {
            log.warn("No order for the given LabResult [" + labResultId + "] found");
            MessageDialog.openError((Shell)new Shell(), (String)Messages.Handler_errorTitleNoOrderFound, (String)Messages.Handler_errorMessageNoOrderFound);
            return null;
        }
        try {
            this.httpsUrl = String.valueOf(this.httpsUrl) + URLEncoder.encode("req=" + orderNr, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            log.error("Enoding not supported", (Throwable)e1);
        }
        try {
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            IWebBrowser externalBrowser = browserSupport.getExternalBrowser();
            externalBrowser.openURL(new URI(this.httpsUrl).toURL());
        }
        catch (Exception e) {
            log.error("Error openen url [{}]: ", (Object)this.httpsUrl, (Object)e);
        }
        return null;
    }
}

