/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.pluginstatistiken.datenquellen;

import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Verrechnet;
import com.hilotec.elexis.pluginstatistiken.schnittstelle.IDatenquelle;
import com.hilotec.elexis.pluginstatistiken.schnittstelle.IDatensatz;
import com.hilotec.elexis.pluginstatistiken.schnittstelle.ITabelle;
import java.util.LinkedList;
import java.util.List;

public class Core
implements IDatenquelle {
    List<ITabelle> tabellen = new LinkedList<ITabelle>();

    public Core() {
        this.tabellen.add(new CoreTabelle("Patient", Patient.class));
        this.tabellen.add(new CoreTabelle("Fall", Fall.class));
        this.tabellen.add(new CoreTabelle("Konsultation", Konsultation.class));
        this.tabellen.add(new CoreTabelle("Verrechnet", Verrechnet.class));
        this.tabellen.add(new CoreTabelle("Kontakt", Kontakt.class));
    }

    @Override
    public String getName() {
        return "Core";
    }

    @Override
    public List<ITabelle> getTabellen() {
        return this.tabellen;
    }

    @Override
    public ITabelle getTabelle(String name) {
        for (ITabelle tab : this.tabellen) {
            if (!tab.getName().equals(name)) continue;
            return tab;
        }
        return null;
    }

    private static class CoreTabelle
    implements ITabelle {
        Class<?> poClass;
        String name;

        public CoreTabelle(String name, Class<?> cl) {
            this.name = name;
            this.poClass = cl;
        }

        @Override
        public List<IDatensatz> getDatensaetze() {
            Query q = new Query(this.poClass);
            List pol = q.execute();
            LinkedList<IDatensatz> datensaetze = new LinkedList<IDatensatz>();
            for (Object o : pol) {
                datensaetze.add(new CoreDatensatz((PersistentObject)o));
            }
            return datensaetze;
        }

        @Override
        public String getName() {
            return this.name;
        }

        private static class CoreDatensatz
        implements IDatensatz {
            PersistentObject obj;

            public CoreDatensatz(PersistentObject po) {
                this.obj = po;
            }

            @Override
            public String getSpalte(String name) {
                return this.obj.get(name);
            }
        }
    }
}

