/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.messwerte.v2.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.util.PlatformHelper;
import ch.elexis.core.ui.util.Log;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.ExHandler;
import com.hilotec.elexis.messwerte.v2.data.Messages;
import com.hilotec.elexis.messwerte.v2.data.MessungTyp;
import com.hilotec.elexis.messwerte.v2.data.Panel;
import com.hilotec.elexis.messwerte.v2.data.typen.IMesswertTyp;
import com.hilotec.elexis.messwerte.v2.data.typen.MesswertTypBool;
import com.hilotec.elexis.messwerte.v2.data.typen.MesswertTypCalc;
import com.hilotec.elexis.messwerte.v2.data.typen.MesswertTypCount;
import com.hilotec.elexis.messwerte.v2.data.typen.MesswertTypData;
import com.hilotec.elexis.messwerte.v2.data.typen.MesswertTypDate;
import com.hilotec.elexis.messwerte.v2.data.typen.MesswertTypEnum;
import com.hilotec.elexis.messwerte.v2.data.typen.MesswertTypNum;
import com.hilotec.elexis.messwerte.v2.data.typen.MesswertTypScale;
import com.hilotec.elexis.messwerte.v2.data.typen.MesswertTypStr;
import java.io.File;
import java.io.FileInputStream;
import java.lang.invoke.CallSite;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.SchemaFactory;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MessungKonfiguration {
    public static final String CONFIG_FILENAME = "messwerte_v2.xml";
    public static final String ELEMENT_VAR = "var";
    public static final String ELEMENT_FORMULA = "formula";
    public static final String ELEMENT_DATATYPE = "datatype";
    public static final String ELEMENT_LAYOUTDESIGN = "design";
    public static final String ELEMENT_LAYOUTLABEL = "label";
    public static final String ELEMENT_LAYOUTLABEL_TEXT = "text";
    public static final String ELEMENT_LAYOUTPANEL = "panel";
    public static final String ELEMENT_LAYOUTPANEL_PLAIN = "plain";
    public static final String ELEMENT_LAYOUTGRID = "grid";
    public static final String ELEMENT_LAYOUTGRID_COLUMNS = "columns";
    public static final String ELEMENT_LAYOUTDISPLAY = "display";
    public static final String ELEMENT_LAYOUTDISPLAY_URL = "url";
    public static final String ELEMENT_LAYOUTDISPLAY_SIZE = "size";
    public static final String ELEMENT_LAYOUTFIELD = "field";
    public static final String ELEMENT_LAYOUTFIELD_REF = "ref";
    public static final String ELEMENT_LAYOUTFIELD_EDITABLE = "editable";
    public static final String ELEMENT_LAYOUTFIELD_VALIDPATTERN = "validpattern";
    public static final String ELEMENT_LAYOUTFIELD_INVALIDMESSAGE = "invalidmessage";
    public static final String ELEMENT_ENUM_OPTION = "option";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_ATTRIBUTE = "attribute";
    public static final String ATTR_SOURCE = "source";
    public static final String ATTR_INTERPRETER = "interpreter";
    public static final String ATTR_DESCRIPTION = "description";
    public static final String ATTR_DEFAULT = "default";
    public static final String ATTR_UNIT = "unit";
    public static final String ATTR_TITLE = "title";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_MAX = "max";
    public static final String ATTR_MIN = "min";
    public static final String ATTR_LINES = "lines";
    public static final String ATTR_LOW_ALERT = "lowAlert";
    public static final String ATTR_LOW_WARNING = "lowWarning";
    public static final String ATTR_HIGH_WARNING = "highWarning";
    public static final String ATTR_HIGH_ALERT = "highAlert";
    public static final String ATTR_FORMATPATTERN = "formatpattern";
    public static final String ATTR_ROUNDMODE = "roundingmode";
    public static final String ATTR_COUNTERMODE = "countermode";
    public static final String ATTR_STARTVALUE = "startvalue";
    public static final String NAME_BOOLFIELD = "boolfield";
    public static final String NAME_CALCFIELD = "calcfield";
    public static final String NAME_COUNTERFIELD = "counterfield";
    public static final String NAME_DATAFIELD = "datafield";
    public static final String NAME_DATEFIELD = "datefield";
    public static final String NAME_ENUMFIELD = "enumfield";
    public static final String NAME_SCALEFIELD = "scalefield";
    public static final String NAME_NUMFIELD = "numfield";
    public static final String NAME_STRINGFIELD = "strfield";
    private static MessungKonfiguration the_one_and_only_instance = null;
    ArrayList<MessungTyp> types;
    private final Log log = Log.get((String)"DataConfiguration");
    private final String defaultFile;

    public static MessungKonfiguration getInstance() {
        if (the_one_and_only_instance == null) {
            the_one_and_only_instance = new MessungKonfiguration();
        }
        return the_one_and_only_instance;
    }

    private MessungKonfiguration() {
        this.types = new ArrayList();
        String bundle_config_xml = PlatformHelper.getBasePath((String)"com.hilotec.elexis.messwerte.v2") + File.separator + "rsc" + File.separator + CONFIG_FILENAME;
        String user_config_xml = CoreHub.localCfg.get("findings/hilotec/configfile", String.valueOf(CoreHub.getWritableUserDir()) + File.separator + CONFIG_FILENAME);
        File f = new File(user_config_xml);
        this.defaultFile = f.exists() ? f.getAbsolutePath() : bundle_config_xml;
        LoggerFactory.getLogger(this.getClass()).info("using config {}", (Object)this.defaultFile);
    }

    private Panel createPanelFromNode(Element n) {
        String type = n.getAttribute(ATTR_TYPE);
        Panel ret = new Panel(type);
        LinkedList<CallSite> attributeList = new LinkedList<CallSite>();
        LinkedList<Panel> panelsList = new LinkedList<Panel>();
        Node node = n.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                String nodename = node.getNodeName();
                if (nodename.equals(ATTR_ATTRIBUTE)) {
                    NamedNodeMap na = node.getAttributes();
                    String nx = na.getNamedItem(ATTR_NAME).getNodeValue() + "=" + na.getNamedItem(ATTR_VALUE).getNodeValue();
                    attributeList.add((CallSite)((Object)nx));
                } else if (nodename.equals(ELEMENT_LAYOUTPANEL)) {
                    panelsList.add(this.createPanelFromNode((Element)node));
                }
            }
            node = node.getNextSibling();
        }
        ret.setAttributes(attributeList.toArray(new String[0]));
        ret.setPanels(panelsList.toArray(new Panel[0]));
        return ret;
    }

    public Boolean readFromXML() {
        return this.readFromXML(this.defaultFile);
    }

    /*
     * Unable to fully structure code
     */
    public Boolean readFromXML(String path) {
        this.types.clear();
        factory = DocumentBuilderFactory.newInstance();
        sfac = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        if (path == null) {
            path = this.defaultFile;
        }
        try {
            schemapath = PlatformHelper.getBasePath((String)"com.hilotec.elexis.messwerte.v2") + File.separator + "rsc" + File.separator + "messwerte.xsd";
            s = sfac.newSchema(new File(schemapath));
            factory.setSchema(s);
            builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    throw exception;
                }
            });
            doc = builder.parse(new FileInputStream(path));
            rootel = doc.getDocumentElement();
            nl = rootel.getElementsByTagName("datatype");
            i = 0;
            while (i < nl.getLength()) {
                edt = (Element)nl.item(i);
                name = edt.getAttribute("name");
                title = edt.getAttribute("title");
                description = edt.getAttribute("description");
                if (title.length() == 0) {
                    title = name;
                }
                nll = edt.getElementsByTagName("design");
                layout = (Element)nll.item(0);
                dt = null;
                if (layout != null) {
                    nl2 = edt.getElementsByTagName("panel");
                    panel = this.createPanelFromNode((Element)nl2.item(0));
                    dt = new MessungTyp(name, title, description, panel);
                } else {
                    dt = new MessungTyp(name, title, description);
                }
                dtf = edt.getChildNodes();
                j = 0;
                while (j < dtf.getLength()) {
                    block40: {
                        block49: {
                            block48: {
                                block47: {
                                    block46: {
                                        block44: {
                                            block43: {
                                                block42: {
                                                    block41: {
                                                        ndtf = dtf.item(j);
                                                        if (ndtf.getNodeType() != 1) break block40;
                                                        edtf = (Element)ndtf;
                                                        fn = edtf.getAttribute("name");
                                                        ft = edtf.getAttribute("title");
                                                        if (ft.equals("")) {
                                                            ft = fn;
                                                        }
                                                        if (!edtf.getNodeName().equals("numfield")) break block41;
                                                        num = new MesswertTypNum(fn, ft, edtf.getAttribute("unit"));
                                                        typ = num;
                                                        if (edtf.hasAttribute("default")) {
                                                            typ.setDefault(edtf.getAttribute("default"));
                                                        }
                                                        if (edtf.hasAttribute("formatpattern")) {
                                                            num.setFormatPattern(edtf.getAttribute("formatpattern"));
                                                        }
                                                        if (edtf.hasAttribute("default")) {
                                                            ((MesswertTypNum)typ).setRoundingMode(edtf.getAttribute("roundingmode"));
                                                        }
                                                        ** GOTO lbl137
                                                    }
                                                    if (!edtf.getNodeName().equals("boolfield")) break block42;
                                                    typ = new MesswertTypBool(fn, ft, edtf.getAttribute("unit"));
                                                    if (edtf.hasAttribute("default")) {
                                                        typ.setDefault(edtf.getAttribute("default"));
                                                    }
                                                    ** GOTO lbl137
                                                }
                                                if (!edtf.getNodeName().equals("strfield")) break block43;
                                                str = new MesswertTypStr(fn, ft, edtf.getAttribute("unit"));
                                                typ = str;
                                                if (edtf.hasAttribute("default")) {
                                                    typ.setDefault(edtf.getAttribute("default"));
                                                }
                                                if (edtf.hasAttribute("lines")) {
                                                    str.setLines(Integer.parseInt(edtf.getAttribute("lines")));
                                                }
                                                ** GOTO lbl137
                                            }
                                            if (!edtf.getNodeName().equals("enumfield")) break block44;
                                            en = new MesswertTypEnum(fn, ft, edtf.getAttribute("unit"));
                                            typ = en;
                                            if (edtf.hasAttribute("default")) {
                                                typ.setDefault(edtf.getAttribute("default"));
                                            }
                                            children = edtf.getChildNodes();
                                            k = 0;
                                            while (k < children.getLength()) {
                                                if ("option".equals(children.item(k).getNodeName()) && children.item(k).getNodeType() == 1) {
                                                    choice = (Element)children.item(k);
                                                    en.addChoice(choice.getAttribute("title"), Integer.parseInt(choice.getAttribute("value")));
                                                }
                                                ++k;
                                            }
                                            if (!typ.getDefault(null).equals("")) ** GOTO lbl137
                                            k = 0;
                                            while (k < children.getLength()) {
                                                block45: {
                                                    if (!"option".equals(children.item(k).getNodeName()) || children.item(k).getNodeType() != 1) break block45;
                                                    choice = (Element)children.item(k);
                                                    typ.setDefault(choice.getAttribute("value"));
                                                    ** GOTO lbl137
                                                }
                                                ++k;
                                            }
                                            ** GOTO lbl137
                                        }
                                        if (!edtf.getNodeName().equals("calcfield")) break block46;
                                        calc = new MesswertTypCalc(fn, ft, edtf.getAttribute("unit"));
                                        typ = calc;
                                        if (edtf.hasAttribute("formatpattern")) {
                                            calc.setFormatPattern(edtf.getAttribute("formatpattern"));
                                        }
                                        if (edtf.hasAttribute("default")) {
                                            typ.setDefault(edtf.getAttribute("default"));
                                        }
                                        ** GOTO lbl137
                                    }
                                    if (!edtf.getNodeName().equals("datafield")) break block47;
                                    data = new MesswertTypData(fn, ft, edtf.getAttribute("unit"));
                                    typ = data;
                                    data.setRefType(edtf.getAttribute("type"));
                                    ** GOTO lbl137
                                }
                                if (!edtf.getNodeName().equals("scalefield")) break block48;
                                scale = new MesswertTypScale(fn, ft, edtf.getAttribute("unit"));
                                typ = scale;
                                if (edtf.hasAttribute("default")) {
                                    scale.setDefault(edtf.getAttribute("default"));
                                }
                                if (edtf.hasAttribute("min")) {
                                    scale.setMin(Integer.parseInt(edtf.getAttribute("min")));
                                }
                                if (edtf.hasAttribute("max")) {
                                    scale.setMax(Integer.parseInt(edtf.getAttribute("max")));
                                }
                                ** GOTO lbl137
                            }
                            if (!edtf.getNodeName().equals("datefield")) break block49;
                            date = new MesswertTypDate(fn, ft, edtf.getAttribute("unit"));
                            typ = date;
                            if (edtf.hasAttribute("default")) {
                                typ.setDefault(edtf.getAttribute("default"));
                            }
                            ** GOTO lbl137
                        }
                        if (!edtf.getNodeName().equals("counterfield")) {
                            if (!edtf.getNodeName().equals("design")) {
                                this.log.log(MessageFormat.format(Messages.MessungKonfiguration_UnknownFieldType, new Object[]{edtf.getNodeName()}), 2);
                            }
                        } else {
                            counter = new MesswertTypCount(fn, ft, edtf.getAttribute("unit"));
                            counter.setCounterMode(edtf.getAttribute("countermode"));
                            typ = counter;
                            if (edtf.hasAttribute("formatpattern")) {
                                counter.setFormatPattern(edtf.getAttribute("formatpattern"));
                            }
                            if (edtf.hasAttribute("startvalue")) {
                                counter.setStartValue(edtf.getAttribute("startvalue"));
                            }
lbl137:
                            // 13 sources

                            if (edtf.hasAttribute(attr = "lowAlert")) {
                                typ.setLowAlertValue(edtf.getAttribute(attr));
                            }
                            if (edtf.hasAttribute(attr = "lowWarning")) {
                                typ.setLowWarningValue(edtf.getAttribute(attr));
                            }
                            if (edtf.hasAttribute(attr = "highWarning")) {
                                typ.setHighWarningValue(edtf.getAttribute(attr));
                            }
                            if (edtf.hasAttribute(attr = "highAlert")) {
                                typ.setHighAlertValue(edtf.getAttribute(attr));
                            }
                            if ((formula = (Element)edtf.getElementsByTagName("formula").item(0)) != null) {
                                typ.setFormula(formula.getTextContent(), formula.getAttribute("interpreter"));
                            }
                            if ((children = edtf.getElementsByTagName("var")) != null) {
                                k = 0;
                                while (k < children.getLength()) {
                                    n = children.item(k);
                                    if (n.getNodeType() == 1) {
                                        var = (Element)n;
                                        typ.addVariable(var.getAttribute("name"), var.getAttribute("source"));
                                    }
                                    ++k;
                                }
                            }
                            dt.addField((IMesswertTyp)typ);
                        }
                    }
                    ++j;
                }
                this.types.add(dt);
                ++i;
            }
            return true;
        }
        catch (Error e) {
            this.log.log(Messages.MessungKonfiguration_ErrorReadXML + e.getMessage(), 2);
        }
        catch (SAXParseException e) {
            ExHandler.handle((Throwable)e);
            SWTHelper.showError((String)Messages.MessungKonfiguration_ErrorInXML, (String)MessageFormat.format(Messages.MessungKonfiguration_ErrorInXMLOnLine, new Object[]{path, e.getLineNumber(), e.getMessage()}));
            this.log.log(Messages.MessungKonfiguration_ErrorReadXML + MessageFormat.format(Messages.MessungKonfiguration_ErrorReadXMLFailure + e.getMessage(), new Object[]{e.getLineNumber()}), 2);
        }
        catch (Exception e) {
            ExHandler.handle((Throwable)e);
            this.log.log(Messages.MessungKonfiguration_ErrorReadXML + e.getMessage(), 2);
        }
        return false;
    }

    public ArrayList<MessungTyp> getTypes() {
        return this.types;
    }

    public MessungTyp getTypeByName(String name) {
        for (MessungTyp t : this.types) {
            if (t.getName().compareTo(name) != 0) continue;
            return t;
        }
        return null;
    }
}

