/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.messwerte.v2.data;

import com.hilotec.elexis.messwerte.v2.data.Messung;
import com.hilotec.elexis.messwerte.v2.data.MessungKonfiguration;
import com.hilotec.elexis.messwerte.v2.data.MessungTyp;
import com.hilotec.elexis.messwerte.v2.data.Messwert;
import com.hilotec.elexis.pluginstatistiken.schnittstelle.IDatenquelle;
import com.hilotec.elexis.pluginstatistiken.schnittstelle.IDatensatz;
import com.hilotec.elexis.pluginstatistiken.schnittstelle.ITabelle;
import java.util.LinkedList;
import java.util.List;

public class PluginstatistikenDatenquelle
implements IDatenquelle {
    List<ITabelle> tabellen = new LinkedList<ITabelle>();

    public PluginstatistikenDatenquelle() {
        MessungKonfiguration konfig = MessungKonfiguration.getInstance();
        for (MessungTyp mt : konfig.getTypes()) {
            this.tabellen.add(new MessungTabelle(mt));
        }
    }

    public String getName() {
        return "Messwert";
    }

    public List<ITabelle> getTabellen() {
        return this.tabellen;
    }

    public ITabelle getTabelle(String name) {
        for (ITabelle tab : this.tabellen) {
            if (!tab.getName().equals(name)) continue;
            return tab;
        }
        return null;
    }

    private static class MessungTabelle
    implements ITabelle {
        MessungTyp typ;

        public MessungTabelle(MessungTyp typ) {
            this.typ = typ;
        }

        public List<IDatensatz> getDatensaetze() {
            List<Messung> messungen = Messung.getMessungen(this.typ);
            LinkedList<IDatensatz> datensaetze = new LinkedList<IDatensatz>();
            for (Messung m : messungen) {
                datensaetze.add(new MessungDatensatz(m));
            }
            return datensaetze;
        }

        public String getName() {
            return this.typ.getName();
        }

        private static class MessungDatensatz
        implements IDatensatz {
            Messung messung;

            public MessungDatensatz(Messung m) {
                this.messung = m;
            }

            public String getSpalte(String name) {
                if (name.equals("Patient")) {
                    return this.messung.getPatient().getId();
                }
                if (name.equals("Datum")) {
                    return this.messung.getDatum();
                }
                Messwert mw = this.messung.getMesswert(name);
                if (mw == null) {
                    return null;
                }
                return mw.getWert();
            }
        }
    }
}

