/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.messwerte.v2.views;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.core.ui.preferences.inputs.InexistingFileOKFileFieldEditor;
import com.hilotec.elexis.messwerte.v2.views.ObservationMigrator;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.slf4j.LoggerFactory;

public class Preferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String CONFIG_FILE = "findings/hilotec/configfile";

    public void init(IWorkbench workbench) {
        this.setPreferenceStore((IPreferenceStore)new SettingsPreferenceStore(CoreHub.localCfg));
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new InexistingFileOKFileFieldEditor(CONFIG_FILE, "Konfigurationsdatei", this.getFieldEditorParent()));
        Button migrationBtn = new Button(this.getFieldEditorParent().getParent(), 8);
        migrationBtn.setText("Messwerte Migration");
        migrationBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                final ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(Preferences.this.getShell());
                try {
                    progressDialog.run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            ObservationMigrator migrator = new ObservationMigrator();
                            Display.getDefault().syncExec(() -> {
                                FileDialog fileDialog = new FileDialog(progressDialog.getShell());
                                fileDialog.setText("Messwerte Migration Mapping");
                                fileDialog.setFilterExtensions(new String[]{"*.properties"});
                                String selected = fileDialog.open();
                                if (StringUtils.isNotBlank((CharSequence)selected)) {
                                    migrator.loadProperties(selected);
                                }
                            });
                            migrator.migrate(monitor);
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException e) {
                    MessageDialog.openError((Shell)Preferences.this.getShell(), (String)"Messwerte konvertieren", (String)"Fehler beim erzeugen der strukturierten Messwerte.");
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error creating structured diagnosis", (Throwable)e);
                }
            }
        });
    }

    public void performApply() {
        CoreHub.localCfg.flush();
    }
}

