/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview.medikarte;

import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Artikel;
import com.hilotec.elexis.kgview.Preferences;
import com.hilotec.elexis.kgview.data.FavMedikament;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FavMedikamentDialog
extends TitleAreaDialog {
    private Artikel artikel;
    private FavMedikament fm;
    private Text tOrdnungszahl;
    private Text tBezeichnung;
    private Text tZweck;
    private Text tEinheit;

    public FavMedikamentDialog(Shell parentShell, Artikel artikel) {
        super(parentShell);
        this.artikel = artikel;
        this.fm = FavMedikament.load(artikel);
    }

    public FavMedikamentDialog(Shell parentShell, FavMedikament med) {
        super(parentShell);
        this.fm = med;
        this.artikel = this.fm.getArtikel();
    }

    protected Control createDialogArea(Composite parent) {
        String ordzahl;
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        Label lLMed = new Label(comp, 0);
        lLMed.setText("Medikament");
        Label lMed = new Label(comp, 0);
        lMed.setText(this.artikel.getName());
        if (Preferences.getOrdnungszahlInFML()) {
            Label lOrd = new Label(comp, 0);
            lOrd.setText("Ordnungszahl");
            this.tOrdnungszahl = SWTHelper.createText((Composite)comp, (int)1, (int)0);
        }
        Label lBez = new Label(comp, 0);
        lBez.setText("Bezeichnung");
        this.tBezeichnung = SWTHelper.createText((Composite)comp, (int)1, (int)0);
        Label lZweck = new Label(comp, 0);
        lZweck.setText("Zweck");
        this.tZweck = SWTHelper.createText((Composite)comp, (int)2, (int)0);
        this.tZweck.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = true;
                }
            }
        });
        Label lEinheit = new Label(comp, 0);
        lEinheit.setText("Einheit");
        this.tEinheit = SWTHelper.createText((Composite)comp, (int)1, (int)0);
        if (this.fm != null) {
            ordzahl = Integer.toString(this.fm.getOrdnungszahl());
            this.tBezeichnung.setText(this.fm.getBezeichnung());
            this.tZweck.setText(this.fm.getZweck());
            this.tEinheit.setText(this.fm.getEinheit());
        } else {
            ordzahl = "0";
            this.tBezeichnung.setText(this.artikel.getName());
        }
        if (this.tOrdnungszahl != null) {
            this.tOrdnungszahl.setText(ordzahl);
        }
        return comp;
    }

    public void okPressed() {
        int ord = 0;
        try {
            if (this.tOrdnungszahl != null) {
                ord = Integer.parseInt(this.tOrdnungszahl.getText());
            }
        }
        catch (NumberFormatException nfe) {
            this.setErrorMessage("Ordnungszahl muss eine Ganzzahl sein!");
            return;
        }
        if (this.fm == null) {
            this.fm = new FavMedikament(this.artikel, ord, this.tBezeichnung.getText(), this.tZweck.getText(), this.tEinheit.getText());
            System.out.println("Created: ");
            System.out.println((Object)this.fm);
        } else {
            if (this.tOrdnungszahl != null) {
                this.fm.setOrdnungszahl(ord);
            }
            this.fm.setBezeichnung(this.tBezeichnung.getText());
            this.fm.setZweck(this.tZweck.getText());
            this.fm.setEinheit(this.tEinheit.getText());
        }
        this.close();
    }
}

