/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview.medikarte;

import ch.elexis.data.Patient;
import ch.elexis.data.Prescription;
import ch.elexis.data.Query;
import ch.rgw.tools.TimeTool;
import com.hilotec.elexis.kgview.Preferences;
import com.hilotec.elexis.kgview.data.FavMedikament;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MedikarteHelpers {
    private static final String PRESC_EI_ORD = "hilotec:ordnungszahl";
    private static final String PRESC_EI_ZWECK = "hilotec:zweck";

    public static List<Prescription> medikarteMedikation(Patient patient, boolean alle) {
        return MedikarteHelpers.medikarteMedikation(patient, alle, false);
    }

    public static List<Prescription> medikarteMedikation(Patient patient, boolean alle, boolean geloescht) {
        Query qbe = new Query(Prescription.class);
        if (geloescht) {
            qbe.clear();
        }
        qbe.add("PatientID", "=", patient.getId());
        qbe.add("RezeptID", "", null);
        if (!alle) {
            qbe.startGroup();
            String today = new TimeTool().toString(9);
            if (Preferences.getMedikarteStopdatumInkl()) {
                qbe.add("DateUntil", ">=", today);
            } else {
                qbe.add("DateUntil", ">", today);
            }
            qbe.or();
            qbe.add("DateUntil", "", null);
            qbe.or();
            qbe.add("DateUntil", "=", "");
            qbe.endGroup();
        }
        List pl = qbe.execute();
        Iterator i = pl.iterator();
        while (i.hasNext()) {
            Prescription p = (Prescription)i.next();
            if (FavMedikament.load(p.getArtikel()) == null) {
                i.remove();
                continue;
            }
            if (p.getDosis().split("-").length == 4) continue;
            i.remove();
        }
        return pl;
    }

    public static String medikarteDatum(Patient patient) {
        List<Prescription> medis = MedikarteHelpers.medikarteMedikation(patient, false);
        TimeTool max = new TimeTool(0L);
        TimeTool cur = new TimeTool();
        for (Prescription p : medis) {
            cur.set(p.getBeginDate());
            if (cur.isAfter(max)) {
                max.set(p.getBeginDate());
            }
            cur.set(p.getEndDate());
            if (!cur.isAfter(max)) continue;
            max.set(p.getEndDate());
        }
        return max.toString(4);
    }

    public static int getOrdnungszahl(Prescription presc) {
        Map ht = presc.getMap("ExtInfo");
        if (ht.containsKey(PRESC_EI_ORD)) {
            return (Integer)ht.get(PRESC_EI_ORD);
        }
        FavMedikament fm = FavMedikament.load(presc.getArtikel());
        if (fm != null) {
            return fm.getOrdnungszahl();
        }
        return 0;
    }

    public static void setOrdnungszahl(Prescription presc, int ord) {
        Map ht = presc.getMap("ExtInfo");
        ht.put(PRESC_EI_ORD, ord);
        presc.setMap("ExtInfo", ht);
    }

    public static String getPZweck(Prescription presc) {
        Map ht = presc.getMap("ExtInfo");
        if (ht.containsKey(PRESC_EI_ZWECK)) {
            return (String)ht.get(PRESC_EI_ZWECK);
        }
        FavMedikament fm = FavMedikament.load(presc.getArtikel());
        if (fm != null) {
            return fm.getZweck();
        }
        return "";
    }

    public static void setPZweck(Prescription presc, String zweck) {
        Map ht = presc.getMap("ExtInfo");
        FavMedikament fm = FavMedikament.load(presc.getArtikel());
        if (fm != null && fm.getZweck().equals(zweck)) {
            ht.remove(PRESC_EI_ZWECK);
        } else {
            ht.put(PRESC_EI_ZWECK, zweck);
        }
        presc.setMap("ExtInfo", ht);
    }
}

