/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview;

import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.data.Prescription;
import ch.elexis.data.Query;
import java.util.List;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    private static final String VERSION_SETTING = "hilotec/kgview/pluginversion";
    public static final String PLUGIN_ID = "com.hilotec.elexis.kgview";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        int ver = ConfigServiceHolder.getGlobal((String)VERSION_SETTING, (int)0);
        if (ver < 1) {
            System.out.println("Update");
            this.updateDosierungen();
            ConfigServiceHolder.setGlobal((String)VERSION_SETTING, (int)1);
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    private void updateDosierungen() {
        Query q = new Query(Prescription.class);
        List pl = q.execute();
        for (Prescription p : pl) {
            try {
                String[] parts = p.getDosis().split("-");
                if (parts == null || parts.length != 4) continue;
                int i = 0;
                while (i < 4) {
                    int n;
                    String[] dp;
                    int z;
                    String d = parts[i];
                    if (d.equals("x")) {
                        parts[i] = "X";
                        break;
                    }
                    if (d.matches("[0-9]+/[0-9]+") && (z = Integer.parseInt((dp = d.split("/"))[0])) > (n = Integer.parseInt(dp[1]))) {
                        int g = z / n;
                        parts[i] = g + " " + (z %= n) + "/" + n;
                    }
                    ++i;
                }
                p.setDosis(parts[0] + "-" + parts[1] + "-" + parts[2] + "-" + parts[3]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

