/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview;

import ch.elexis.core.ui.UiDesk;
import com.hilotec.elexis.kgview.Preferences;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.ScrolledFormText;

class ScrollHelper
implements KeyListener,
DisposeListener,
FocusListener {
    private ScrolledFormText comp;
    private Direction dir;
    private Timer timer;
    private final int scPeriod;
    private final int scDistUp;
    private final int scDistDown;

    public ScrollHelper(ScrolledFormText comp) {
        this.comp = comp;
        FormText ft = comp.getFormText();
        ft.addDisposeListener((DisposeListener)this);
        ft.addKeyListener((KeyListener)this);
        comp.addKeyListener((KeyListener)this);
        ft.addFocusListener((FocusListener)this);
        this.scPeriod = Preferences.getArchivKGScrollPeriod();
        this.scDistUp = Preferences.getArchivKGScrollDistUp();
        this.scDistDown = Preferences.getArchivKGScrollDistDown();
    }

    private void start() {
        if (this.timer != null) {
            return;
        }
        TimerTask tt = new TimerTask(){

            @Override
            public void run() {
                UiDesk.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ScrollHelper.this.tickInGUI();
                    }
                });
            }
        };
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(tt, 0L, (long)this.scPeriod);
    }

    private void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void tickInGUI() {
        Point p = this.comp.getOrigin();
        Point q = this.comp.getContent().getSize();
        if (this.dir == Direction.DOWN && p.y < q.y) {
            p.y = Math.min(q.y, p.y + this.scDistDown);
        } else if (this.dir == Direction.UP && p.y > 0) {
            p.y = Math.max(0, p.y - this.scDistUp);
        }
        this.comp.setOrigin(p);
    }

    private boolean isUp(int kc) {
        return kc == 0x1000001 || kc == 0x1000005;
    }

    private boolean isDown(int kc) {
        return kc == 0x1000002 || kc == 0x1000006;
    }

    public void keyReleased(KeyEvent e) {
        if (this.isUp(e.keyCode) || this.isDown(e.keyCode)) {
            this.stop();
        }
    }

    public void keyPressed(KeyEvent e) {
        if (this.isDown(e.keyCode)) {
            this.dir = Direction.DOWN;
            this.start();
        } else if (this.isUp(e.keyCode)) {
            this.dir = Direction.UP;
            this.start();
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        this.stop();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.stop();
    }

    static enum Direction {
        UP,
        DOWN;

    }
}

