/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview.data;

import ch.elexis.core.data.interfaces.IDataAccess;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Prescription;
import ch.rgw.tools.Result;
import ch.rgw.tools.StringTool;
import com.hilotec.elexis.kgview.ArchivKG;
import com.hilotec.elexis.kgview.Preferences;
import com.hilotec.elexis.kgview.data.FavMedikament;
import com.hilotec.elexis.kgview.data.KonsData;
import com.hilotec.elexis.kgview.diagnoseliste.DiagnoselisteItem;
import com.hilotec.elexis.kgview.medikarte.MedikarteEintragComparator;
import com.hilotec.elexis.kgview.medikarte.MedikarteHelpers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;

public class DataAccessor
implements IDataAccess {
    private static final String[] fields = new String[]{"JetzigesLeiden", "JetzigesLeidenICPC", "AllgStatus", "LokStatus", "Prozedere", "ProzedereICPC", "Diagnose", "DiagnoseICPC"};

    public String getName() {
        return "Hilotec-KG";
    }

    public String getDescription() {
        return "Daten aus dem Hilotec-KG-Plugin";
    }

    public List<IDataAccess.Element> getList() {
        ArrayList<IDataAccess.Element> res = new ArrayList<IDataAccess.Element>(fields.length);
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            res.add(new IDataAccess.Element(IDataAccess.TYPE.STRING, s, s, Konsultation.class, 0));
            ++n2;
        }
        return res;
    }

    private String[] emptyRow(int count) {
        String[] row = new String[count];
        int i = 0;
        while (i < row.length) {
            row[i] = "";
            ++i;
        }
        return row;
    }

    private Result<Object> generiereMedikarte(Patient pat) {
        String ev4;
        String[] evs_config;
        List<Prescription> l = MedikarteHelpers.medikarteMedikation(pat, false);
        if (l.isEmpty()) {
            return new Result((Object)new String[0][]);
        }
        TreeSet<String> evs = new TreeSet<String>();
        HashMap prescs = new HashMap();
        for (Prescription p : l) {
            String ev2 = p.getBemerkung();
            evs.add(ev2);
            if (!prescs.containsKey(ev2)) {
                prescs.put(ev2, new ArrayList());
            }
            ((List)prescs.get(ev2)).add(p);
        }
        for (String ev3 : evs) {
            List pl = (List)prescs.get(ev3);
            Collections.sort(pl, new MedikarteEintragComparator(MedikarteEintragComparator.Sortierung.ORDNUNGSZAHL));
        }
        int extra = 2 * evs.size() - (evs.contains("") ? 2 : 1);
        String[][] res = new String[l.size() + extra][];
        String[] evs_ordered = new String[evs.size()];
        int i = 0;
        if (evs.contains("")) {
            evs_ordered[i++] = "";
            evs.remove("");
        }
        String[] stringArray = evs_config = Preferences.getEinnahmevorschriften();
        int n = evs_config.length;
        int n2 = 0;
        while (n2 < n) {
            ev4 = stringArray[n2];
            if (evs.contains(ev4)) {
                evs_ordered[i++] = ev4;
                evs.remove(ev4);
            }
            ++n2;
        }
        for (String ev4 : evs) {
            evs_ordered[i++] = ev4;
            evs.remove(ev4);
        }
        i = 0;
        stringArray = evs_ordered;
        n = evs_ordered.length;
        int n3 = 0;
        while (n3 < n) {
            ev4 = stringArray[n3];
            if (i != 0) {
                res[i++] = this.emptyRow(7);
            }
            if (!ev4.equals("")) {
                String[] row = this.emptyRow(7);
                row[0] = "_" + ev4 + "_";
                res[i++] = row;
            }
            for (Prescription p : (List)prescs.get(ev4)) {
                FavMedikament fm = FavMedikament.load(p.getArtikel());
                String[] dosierung = p.getDosis().split("-");
                if (dosierung.length != 4 || fm == null) continue;
                String[] row = new String[7];
                row[0] = fm.getBezeichnung();
                row[5] = fm.getEinheit();
                row[6] = MedikarteHelpers.getPZweck(p);
                row[1] = dosierung[0];
                row[2] = dosierung[1];
                row[3] = dosierung[2];
                row[4] = dosierung[3];
                res[i++] = row;
            }
            ++n3;
        }
        return new Result((Object)res);
    }

    private int dliDepth(DiagnoselisteItem item) {
        if (item == null) {
            return 0;
        }
        int depth = 0;
        for (DiagnoselisteItem child : item.getChildren()) {
            depth = Math.max(this.dliDepth(child), depth);
        }
        return depth + 1;
    }

    private void generiereDLIZeilen(DiagnoselisteItem item, int skip, boolean ignore, List<String[]> dest) {
        if (!ignore) {
            String[] zeile = new String[++skip];
            zeile[skip - 1] = item.getText();
            dest.add(zeile);
        }
        for (DiagnoselisteItem child : item.getChildren()) {
            this.generiereDLIZeilen(child, skip, false, dest);
        }
    }

    private Result<Object> generiereDiagnoseliste(Patient pat) {
        DiagnoselisteItem root = DiagnoselisteItem.getRoot(pat, 0);
        int depth = this.dliDepth(root);
        if (depth <= 1) {
            return new Result((Object)"");
        }
        ArrayList<String[]> rows = new ArrayList<String[]>();
        this.generiereDLIZeilen(root, 0, true, rows);
        String[][] res = new String[rows.size()][];
        int i = 0;
        for (String[] row : rows) {
            res[i++] = row;
        }
        return new Result((Object)res);
    }

    private Result<Object> generiereProblemliste(Patient pat) {
        ArrayList<String[]> pl = new ArrayList<String[]>();
        ArrayList<Konsultation> kl = ArchivKG.getKonsultationen(pat, false);
        for (Konsultation k : kl) {
            KonsData kd = KonsData.load(k);
            if (kd == null || StringTool.isNothing((Object)kd.getDiagnose())) continue;
            pl.add(new String[]{k.getDatum(), kd.getDiagnose()});
        }
        return new Result(pl.toArray((T[])new String[pl.size()][]));
    }

    public Result<Object> getObject(String descriptor, PersistentObject dependentObject, String dates, String[] params) {
        if (dependentObject instanceof Patient && descriptor.equals("Medikarte")) {
            return this.generiereMedikarte((Patient)dependentObject);
        }
        if (dependentObject instanceof Patient && descriptor.equals("Medikarte.Datum")) {
            return new Result((Object)MedikarteHelpers.medikarteDatum((Patient)dependentObject));
        }
        if (dependentObject instanceof Patient && descriptor.equals("Diagnoseliste")) {
            return this.generiereDiagnoseliste((Patient)dependentObject);
        }
        if (dependentObject instanceof Patient && descriptor.equals("Problemliste")) {
            return this.generiereProblemliste((Patient)dependentObject);
        }
        if (!(dependentObject instanceof Konsultation)) {
            return new Result(Result.SEVERITY.ERROR, 1, "Ung\u00fcltiger Parameter", (Object)dependentObject, true);
        }
        Konsultation kons = (Konsultation)dependentObject;
        KonsData data = new KonsData(kons);
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            if (f.equals(descriptor)) {
                return new Result((Object)StringTool.unNull((String)data.get(f)));
            }
            ++n2;
        }
        return new Result(Result.SEVERITY.ERROR, 1, "Ung\u00fcltiges Feld", (Object)dependentObject, true);
    }
}

