/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview.diagnoseliste;

import com.hilotec.elexis.kgview.diagnoseliste.DNode;
import java.io.ByteArrayInputStream;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class DLParser {
    DLParser() {
    }

    public DNode parse(String html) {
        DNode dn = this.parseItems(html);
        if (dn == null) {
            dn = this.parseManualList(html);
        }
        System.out.println(dn);
        if (dn != null) {
            for (DNode c : dn.children) {
                System.out.println(c.text);
            }
        }
        return dn;
    }

    private Element parseXML(String code) {
        try {
            byte[] bytes = code.getBytes();
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setValidating(false);
            dbFactory.setNamespaceAware(true);
            dbFactory.setIgnoringComments(false);
            dbFactory.setIgnoringElementContentWhitespace(false);
            dbFactory.setExpandEntityReferences(false);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(new ByteArrayInputStream(bytes));
            return doc.getDocumentElement();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private DNode parseItems(String html) {
        System.out.println("{{" + html + "}}");
        Element e = this.parseXML(html);
        if (e == null) {
            return null;
        }
        DNode dn = new DNode();
        this.parseUL(e, dn);
        return dn;
    }

    private void parseUL(Element e, DNode dn) {
        if (!e.getNodeName().equals("ul")) {
            return;
        }
        NodeList nl = e.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n instanceof Element && n.getNodeName().equals("li")) {
                Element li = (Element)n;
                li.normalize();
                this.parseLI(li, dn.newChild());
            }
            ++i;
        }
    }

    private void parseLI(Element li, DNode dn) {
        NodeList nl = li.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n instanceof Element) {
                Element e = (Element)n;
                e.normalize();
                if (e.getNodeName().equals("ul")) {
                    this.parseUL(e, dn);
                } else if (e.getNodeName().equals("br")) {
                    dn.append("\n");
                } else if (e.getNodeName().equals("p")) {
                    dn.append("\n");
                    this.parseLI(e, dn);
                    dn.append("\n");
                } else {
                    this.parseLI(e, dn);
                }
            } else if (n instanceof Text) {
                Text t = (Text)n;
                dn.append(t.getTextContent().trim());
            }
            ++i;
        }
    }

    private DNode parseManualList(String html) {
        try {
            String enc = "utf-8";
            if (System.getProperty("os.name").startsWith("Windows")) {
                enc = "iso-8859-1";
            }
            html = "<?xml version=\"1.0\" encoding=\"" + enc + "\"?><root>\n" + (String)html + "\n</root>";
            html = ((String)html).replaceAll("<br>", "<br/>");
            html = ((String)html).replaceAll("<BR>", "<br/>");
            html = ((String)html).replaceAll("ALIGN=JUSTIFY", "");
            html = ((String)html).replaceAll("&shy;", "-");
            System.out.println("Cleaned xml:\n{{" + (String)html + "}}");
            Element root = this.parseXML((String)html);
            NodeList nl = root.getChildNodes();
            Stack<DNode> stack = new Stack<DNode>();
            stack.push(new DNode());
            int i = 0;
            while (i < nl.getLength()) {
                Node n = nl.item(i);
                if (n instanceof Element) {
                    Element e = (Element)n;
                    String txt = e.getTextContent();
                    if (!e.getNodeName().equalsIgnoreCase("p") || !txt.startsWith("-")) {
                        throw new Exception("Nicht p-Element");
                    }
                    String c = e.getAttribute("class");
                    if (c.isEmpty()) {
                        c = e.getAttribute("CLASS");
                    }
                    if (!(c = c.toLowerCase()).matches("liste?-[0-9]-.*")) {
                        throw new Exception("p-Element ohne passende class");
                    }
                    int lvl = Integer.parseInt(c.replaceAll("^liste?-", "").substring(0, 1));
                    while (stack.size() > lvl) {
                        stack.pop();
                    }
                    if (stack.size() < lvl) {
                        throw new Exception("Stack underflow beim parsen");
                    }
                    DNode dn = ((DNode)stack.peek()).newChild();
                    this.parseManualP(dn, e);
                    dn.text = dn.text.substring(1).replaceAll("[ \t\n\r]+", " ");
                    dn.text = dn.text.trim();
                    stack.push(dn);
                }
                ++i;
            }
            while (stack.size() > 1) {
                stack.pop();
            }
            return (DNode)stack.pop();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void parseManualP(DNode dn, Element e) throws Exception {
        e.normalize();
        NodeList nl = e.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n instanceof Text) {
                dn.append(n.getNodeValue());
            } else if (n instanceof Element && n.getNodeName().equalsIgnoreCase("br")) {
                dn.append("\n");
            } else {
                throw new Exception("Ungueltigen Node angetroffen: {" + n.getNodeName() + "}");
            }
            ++i;
        }
    }
}

