/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.data.Anwender;
import ch.elexis.data.Konsultation;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.Arrays;
import java.util.HashSet;

public class KonsData
extends PersistentObject {
    public static final String VERSION = "9";
    public static final String PLUGIN_ID = "com.hilotec.elexis.kgview";
    private static final String TABLENAME = "COM_HILOTEC_ELEXIS_KGVIEW_KONSDATA";
    public static final String FLD_JETZLEIDEN = "JetzigesLeiden";
    public static final String FLD_JETZLEIDEN_ICPC = "JetzigesLeidenICPC";
    public static final String FLD_ALLGSTATUS = "AllgStatus";
    public static final String FLD_LOKSTATUS = "LokStatus";
    public static final String FLD_PROZEDERE = "Prozedere";
    public static final String FLD_PROZEDERE_ICPC = "ProzedereICPC";
    public static final String FLD_DIAGNOSE = "Diagnose";
    public static final String FLD_DIAGNOSE_ICPC = "DiagnoseICPC";
    public static final String FLD_THERAPIE = "Therapie";
    public static final String FLD_VERLAUF = "Verlauf";
    public static final String FLD_ROENTGEN = "Roentgen";
    public static final String FLD_EKG = "EKG";
    public static final String FLD_KONSZEIT = "KonsZeit";
    public static final String FLD_KONSBEGINN = "KonsBeginn";
    public static final String FLD_KONSTYP = "KonsTyp";
    public static final String FLD_AUTOR = "Autor";
    public static final int KONSTYP_NORMAL = 0;
    public static final int KONSTYP_TELEFON = 1;
    public static final int KONSTYP_HAUSBESUCH = 2;
    private static final String[] KGFIELDS = new String[]{"JetzigesLeiden", "JetzigesLeidenICPC", "AllgStatus", "LokStatus", "Prozedere", "ProzedereICPC", "Diagnose", "DiagnoseICPC", "Therapie", "Verlauf", "Roentgen", "EKG"};
    private static final HashSet<String> KGFIELD_SET = new HashSet<String>(Arrays.asList(KGFIELDS));
    private static final String create = "CREATE TABLE COM_HILOTEC_ELEXIS_KGVIEW_KONSDATA (  ID\t\t\t\tVARCHAR(25) PRIMARY KEY,   lastupdate \tBIGINT,   deleted\t\tCHAR(1) DEFAULT '0',   JetzLeiden\t\tTEXT,   JetzLeidenICPC\tTEXT,   AllgStatus\t\tTEXT,   LokStatus\t\tTEXT,   Prozedere\t\tTEXT,   ProzedereICPC\tTEXT,   Diagnose\t\tTEXT,   DiagnoseICPC\tTEXT,   Therapie\t\tTEXT,   Verlauf\t\tTEXT,   Roentgen\t\tTEXT,   EKG\t\t\tTEXT,   KonsZeit \t\tBIGINT DEFAULT 0,   KonsBeginn     BIGINT,    KonsTyp\t\tSMALLINT DEFAULT 0,   Autor          VARCHAR(25)  );INSERT INTO COM_HILOTEC_ELEXIS_KGVIEW_KONSDATA (ID, JetzLeiden) VALUES \t('VERSION', '9');";
    private static final String up_1to2 = "ALTER TABLE COM_HILOTEC_ELEXIS_KGVIEW_KONSDATA  ADD JetzLeidenICPC\tTEXT AFTER JetzLeiden,  ADD ProzedereICPC \tTEXT AFTER Prozedere,  ADD DiagnoseICPC \tTEXT AFTER Diagnose;UPDATE COM_HILOTEC_ELEXIS_KGVIEW_KONSDATA SET JetzLeiden = '2' WHERE  ID LIKE 'VERSION';";
    private static final String up_2to3 = "ALTER TABLE COM_HILOTEC_ELEXIS_KGVIEW_KONSDATA  ADD Therapie\tTEXT AFTER DiagnoseICPC,  ADD Verlauf \tTEXT AFTER Therapie;UPDATE COM_HILOTEC_ELEXIS_KGVIEW_KONSDATA SET JetzLeiden = '3' WHERE  ID LIKE 'VERSION';";
    private static final String up_3to4 = "ALTER TABLE COM_HILOTEC_ELEXIS_KGVIEW_KONSDATA  ADD Roentgen\tTEXT AFTER Verlauf,  ADD EKG\t\tTEXT AFTER Roentgen;UPDATE COM_HILOTEC_ELEXIS_KGVIEW_KONSDATA SET JetzLeiden = '4' WHERE  ID LIKE 'VERSION';";
    private static final String up_4to5 = "ALTER TABLE COM_HILOTEC_ELEXIS_KGVIEW_KONSDATA  ADD KonsBeginn\tBIGINT AFTER KonsZeit;UPDATE COM_HILOTEC_ELEXIS_KGVIEW_KONSDATA SET JetzLeiden = '5' WHERE  ID LIKE 'VERSION';";
    private static final String up_5to6 = "ALTER TABLE COM_HILOTEC_ELEXIS_KGVIEW_KONSDATA  CHANGE KonsZeit KonsZeit BIGINT DEFAULT 0;UPDATE COM_HILOTEC_ELEXIS_KGVIEW_KONSDATA SET KonsZeit = 0 WHERE  KonsZeit IS NULL;UPDATE COM_HILOTEC_ELEXIS_KGVIEW_KONSDATA SET JetzLeiden = '6' WHERE  ID LIKE 'VERSION';";
    private static final String up_6to7 = "ALTER TABLE COM_HILOTEC_ELEXIS_KGVIEW_KONSDATA  ADD IstTelefon\t\tCHAR(1) DEFAULT '0' AFTER KonsBeginn;UPDATE COM_HILOTEC_ELEXIS_KGVIEW_KONSDATA SET JetzLeiden = '7' WHERE  ID LIKE 'VERSION';";
    private static final String up_7to8 = "ALTER TABLE COM_HILOTEC_ELEXIS_KGVIEW_KONSDATA  ADD Autor\t\tVARCHAR(25) AFTER IstTelefon;UPDATE COM_HILOTEC_ELEXIS_KGVIEW_KONSDATA SET JetzLeiden = '8' WHERE  ID LIKE 'VERSION';";
    private static final String up_8to9 = "ALTER TABLE COM_HILOTEC_ELEXIS_KGVIEW_KONSDATA  ADD KonsTyp\tSMALLINT DEFAULT 0 AFTER IstTelefon;UPDATE COM_HILOTEC_ELEXIS_KGVIEW_KONSDATA SET KonsTyp = 1 WHERE  IstTelefon = 1;ALTER TABLE COM_HILOTEC_ELEXIS_KGVIEW_KONSDATA  DROP IstTelefon; UPDATE COM_HILOTEC_ELEXIS_KGVIEW_KONSDATA SET JetzLeiden = '9' WHERE  ID LIKE 'VERSION';";

    static {
        KonsData.addMapping((String)TABLENAME, (String[])new String[]{"JetzigesLeiden=JetzLeiden", "JetzigesLeidenICPC=JetzLeidenICPC", FLD_ALLGSTATUS, FLD_LOKSTATUS, FLD_PROZEDERE, FLD_PROZEDERE_ICPC, FLD_DIAGNOSE, FLD_DIAGNOSE_ICPC, FLD_THERAPIE, FLD_VERLAUF, FLD_ROENTGEN, FLD_EKG, FLD_KONSZEIT, FLD_KONSBEGINN, FLD_KONSTYP, FLD_AUTOR});
        KonsData.checkTable();
    }

    private static void checkTable() {
        KonsData check = KonsData.load("VERSION");
        if (!check.exists()) {
            KonsData.createOrModifyTable((String)create);
        } else {
            if (check.getJetzigesLeiden().equals("1")) {
                KonsData.createOrModifyTable((String)up_1to2);
            }
            if (check.getJetzigesLeiden().equals("2")) {
                KonsData.createOrModifyTable((String)up_2to3);
            }
            if (check.getJetzigesLeiden().equals("3")) {
                KonsData.createOrModifyTable((String)up_3to4);
            }
            if (check.getJetzigesLeiden().equals("4")) {
                KonsData.createOrModifyTable((String)up_4to5);
            }
            if (check.getJetzigesLeiden().equals("5")) {
                KonsData.createOrModifyTable((String)up_5to6);
            }
            if (check.getJetzigesLeiden().equals("6")) {
                KonsData.createOrModifyTable((String)up_6to7);
            }
            if (check.getJetzigesLeiden().equals("7")) {
                KonsData.createOrModifyTable((String)up_7to8);
            }
            if (check.getJetzigesLeiden().equals("8")) {
                KonsData.createOrModifyTable((String)up_8to9);
            }
        }
    }

    public static KonsData load(String id) {
        return new KonsData(id);
    }

    public static KonsData load(Konsultation kons) {
        return KonsData.load(kons.getId());
    }

    protected KonsData() {
    }

    protected KonsData(String id) {
        super(id);
    }

    public KonsData(Konsultation kons) {
        super(kons.getId());
        if (!this.exists()) {
            this.create(kons.getId());
            this.set(FLD_KONSBEGINN, Long.toString(System.currentTimeMillis()));
        }
    }

    public String getLabel() {
        return this.getKonsultation().getLabel();
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public String getJetzigesLeiden() {
        return this.get(FLD_JETZLEIDEN);
    }

    public String getJetzigesLeidenICPC() {
        return this.get(FLD_JETZLEIDEN_ICPC);
    }

    public String getAllgemeinstatus() {
        return this.get(FLD_ALLGSTATUS);
    }

    public String getLokalstatus() {
        return this.get(FLD_LOKSTATUS);
    }

    public String getProzedere() {
        return this.get(FLD_PROZEDERE);
    }

    public String getProzedereICPC() {
        return this.get(FLD_PROZEDERE_ICPC);
    }

    public String getDiagnose() {
        return this.get(FLD_DIAGNOSE);
    }

    public String getDiagnoseICPC() {
        return this.get(FLD_DIAGNOSE_ICPC);
    }

    public String getTherapie() {
        return this.get(FLD_THERAPIE);
    }

    public String getVerlauf() {
        return this.get(FLD_VERLAUF);
    }

    public String getRoentgen() {
        return this.get(FLD_ROENTGEN);
    }

    public String getEKG() {
        return this.get(FLD_EKG);
    }

    public long getKonsZeit() {
        return Long.parseLong(this.get(FLD_KONSZEIT));
    }

    public String getKonsBeginn() {
        String ts = this.get(FLD_KONSBEGINN);
        if (ts == null || ts.equals("")) {
            return "";
        }
        TimeTool t = new TimeTool();
        t.setTimeInMillis(Long.parseLong(ts));
        return t.toString(3);
    }

    public Konsultation getKonsultation() {
        return Konsultation.load((String)this.getId());
    }

    public int getKonsTyp() {
        String tel = this.get(FLD_KONSTYP);
        tel = StringTool.isNothing((Object)tel) ? "0" : tel;
        return Integer.parseInt(tel);
    }

    public Anwender getAutor() {
        String id = this.get(FLD_AUTOR);
        if (!StringTool.isNothing((Object)id)) {
            Anwender aw = Anwender.load((String)id);
            return aw;
        }
        return null;
    }

    public void setJetzigesLeiden(String txt) {
        this.set(FLD_JETZLEIDEN, txt);
    }

    public void setAllgemeinstatus(String txt) {
        this.set(FLD_ALLGSTATUS, txt);
    }

    public void setLokalstatus(String txt) {
        this.set(FLD_LOKSTATUS, txt);
    }

    public void setProzedere(String txt) {
        this.set(FLD_PROZEDERE, txt);
    }

    public void setDiagnose(String txt) {
        this.set(FLD_DIAGNOSE, txt);
    }

    public void setTherapie(String txt) {
        this.set(FLD_THERAPIE, txt);
    }

    public void setVerlauf(String txt) {
        this.set(FLD_VERLAUF, txt);
    }

    public void setRoentgen(String txt) {
        this.set(FLD_ROENTGEN, txt);
    }

    public void setEKG(String txt) {
        this.set(FLD_EKG, txt);
    }

    public void setKonsBeginn(long zeit) {
        this.set(FLD_KONSBEGINN, Long.toString(zeit));
    }

    public void setKonsZeit(long zeit) {
        this.set(FLD_KONSZEIT, Long.toString(zeit));
    }

    public void setKonsTyp(int typ) {
        this.set(FLD_KONSTYP, Integer.toString(typ));
    }

    public void setAutor(Anwender anw) {
        String id = "";
        if (anw != null) {
            id = anw.getId();
        }
        this.set(FLD_AUTOR, id);
    }

    public boolean set(String field, String value) {
        if (KGFIELD_SET.contains(field)) {
            Anwender au = this.getAutor();
            if (au == null) {
                this.setAutor(CoreHub.getLoggedInContact());
            } else {
                if (!au.equals((Object)CoreHub.getLoggedInContact())) {
                    throw new RuntimeException("Nur Autor kann Krankengeschichte veraendern!");
                }
                if (StringTool.isNothing((Object)value)) {
                    boolean nonempty = false;
                    int i = 0;
                    while (i < KGFIELDS.length && !nonempty) {
                        nonempty |= !StringTool.isNothing((Object)this.get(KGFIELDS[i]));
                        ++i;
                    }
                    if (!nonempty) {
                        this.set(FLD_AUTOR, "");
                    }
                }
            }
        }
        return super.set(field, value);
    }

    public boolean isEditOK() {
        Anwender au = this.getAutor();
        return au == null || au.equals((Object)CoreHub.getLoggedInContact());
    }

    public boolean isDragOK() {
        return true;
    }
}

