/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.util.PersistentObjectDragSource;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.StringTool;
import com.hilotec.elexis.kgview.ArchivKG;
import com.hilotec.elexis.kgview.data.KonsData;
import jakarta.inject.Inject;
import java.util.ArrayList;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.part.ViewPart;

public class Therapieliste
extends ViewPart
implements IRefreshable {
    public static final String ID = "com.hilotec.elexis.kgview.Therapieliste";
    private TableViewer tv;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener((ViewPart)this);

    public void createPartControl(Composite parent) {
        this.tv = new TableViewer(parent);
        Table t = this.tv.getTable();
        t.setHeaderVisible(true);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(70));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(70));
        t.setLayout((Layout)layout);
        TableColumn tc = new TableColumn(t, 0);
        tc.setText("Datum");
        tc = new TableColumn(t, 0);
        tc.setText("Therapie");
        this.tv.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private Patient pat;

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.pat = (Patient)newInput;
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                ArrayList<Konsultation> kl = ArchivKG.getKonsultationen(this.pat, false);
                ArrayList<KonsData> list = new ArrayList<KonsData>(kl.size());
                for (Konsultation k : kl) {
                    KonsData kd = KonsData.load(k);
                    if (kd == null || StringTool.isNothing((Object)kd.getTherapie())) continue;
                    list.add(kd);
                }
                return list.toArray();
            }
        });
        this.tv.setLabelProvider((IBaseLabelProvider)new OwnerDrawLabelProvider(){

            private String getText(KonsData kd, Event event) {
                if (event.index == 0) {
                    return kd.getKonsultation().getDatum();
                }
                return StringTool.unNull((String)kd.getTherapie());
            }

            protected void paint(Event event, Object element) {
                KonsData kd = (KonsData)((Object)element);
                String text = this.getText(kd, event);
                event.gc.drawText(text, event.x, event.y, true);
            }

            protected void measure(Event event, Object element) {
                KonsData kd = (KonsData)((Object)element);
                String text = this.getText(kd, event);
                Point size = event.gc.textExtent(text);
                event.width = Therapieliste.this.tv.getTable().getColumn(event.index).getWidth();
                if (event.width == 0) {
                    event.width = 1;
                }
                int lines = size.x / event.width + 1;
                event.height = size.y * lines;
            }
        });
        this.tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TableItem[] tis = Therapieliste.this.tv.getTable().getSelection();
                if (tis.length != 1) {
                    return;
                }
                KonsData kd = (KonsData)((Object)tis[0].getData());
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)kd.getKonsultation());
            }
        });
        new PersistentObjectDragSource((StructuredViewer)this.tv);
        this.tv.setInput((Object)ElexisEventDispatcher.getSelectedPatient());
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        super.dispose();
    }

    public void setFocus() {
    }

    @Optional
    @Inject
    void crudEncounter(@UIEventTopic(value="info/elexis/model/*") IEncounter encounter) {
        CoreUiUtil.runAsyncIfActive(() -> this.tv.refresh(), (Object)this.tv);
    }

    @Inject
    void activePatient(@Optional IPatient patient) {
        CoreUiUtil.runAsyncIfActive(() -> {
            Patient p = (Patient)NoPoUtil.loadAsPersistentObject((Identifiable)patient);
            this.tv.setInput((Object)p);
        }, (Object)this.tv);
    }

    public void refresh() {
        this.activePatient(ContextServiceHolder.get().getActivePatient().orElse(null));
    }
}

