/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview.medikarte;

import ch.elexis.data.Artikel;
import ch.elexis.data.Prescription;
import ch.rgw.tools.TimeTool;
import com.hilotec.elexis.kgview.data.FavMedikament;
import com.hilotec.elexis.kgview.medikarte.MedikarteHelpers;
import java.util.Calendar;
import java.util.Comparator;

public class MedikarteEintragComparator
implements Comparator<Prescription> {
    Sortierung sort;

    public MedikarteEintragComparator(Sortierung sort) {
        this.sort = sort;
    }

    private int oz(int o) {
        return o == 0 ? Integer.MAX_VALUE : o;
    }

    private int compareNurLabel(Prescription p1, Prescription p2) {
        Artikel a1 = p1.getArtikel();
        Artikel a2 = p2.getArtikel();
        FavMedikament fm1 = FavMedikament.load(a1);
        FavMedikament fm2 = FavMedikament.load(a2);
        if (fm1 != null && fm2 != null) {
            return fm1.getBezeichnung().compareTo(fm2.getBezeichnung());
        }
        return a1.getLabel().compareTo(a2.getLabel());
    }

    private int compareNurChronologisch(Prescription p1, Prescription p2) {
        TimeTool b1 = new TimeTool(p1.getBeginDate());
        TimeTool b2 = new TimeTool(p2.getBeginDate());
        TimeTool e1 = new TimeTool(p1.getEndDate());
        TimeTool e2 = new TimeTool(p2.getEndDate());
        int bc = b1.compareTo((Calendar)b2);
        if (bc != 0) {
            return -bc;
        }
        return -e1.compareTo((Calendar)e2);
    }

    private int compareOz(Prescription p1, Prescription p2) {
        Integer o2;
        Integer o1 = this.oz(MedikarteHelpers.getOrdnungszahl(p1));
        if (!o1.equals(o2 = Integer.valueOf(this.oz(MedikarteHelpers.getOrdnungszahl(p2))))) {
            return o1.compareTo(o2);
        }
        return this.compareNurLabel(p1, p2);
    }

    private int compareCh(Prescription p1, Prescription p2) {
        int ord = this.compareNurChronologisch(p1, p2);
        if (ord != 0) {
            return ord;
        }
        return this.compareNurLabel(p1, p2);
    }

    public int compareAl(Prescription p1, Prescription p2) {
        int ord = this.compareNurLabel(p1, p2);
        if (ord != 0) {
            return ord;
        }
        return this.compareCh(p1, p2);
    }

    @Override
    public int compare(Prescription p1, Prescription p2) {
        switch (this.sort) {
            case ALPHABETISCH: {
                return this.compareAl(p1, p2);
            }
            case CHRONOLOGISCH: {
                return this.compareCh(p1, p2);
            }
            case ORDNUNGSZAHL: {
                return this.compareOz(p1, p2);
            }
        }
        throw new RuntimeException("Unbekannte Sortierungsreihenfolge");
    }

    public static enum Sortierung {
        ALPHABETISCH,
        CHRONOLOGISCH,
        ORDNUNGSZAHL;

    }
}

