/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.utils;

import ch.unibe.iam.scg.archie.ArchieActivator;
import ch.unibe.iam.scg.archie.annotations.GetProperty;
import ch.unibe.iam.scg.archie.annotations.SetProperty;
import ch.unibe.iam.scg.archie.model.AbstractDataProvider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ProviderHelper {
    private static final int GETTER = 0;
    private static final int SETTER = 1;

    public static Map<String, Object> getGetterMap(AbstractDataProvider provider, boolean sorted) {
        LinkedHashMap<String, Object> getterMap = new LinkedHashMap<String, Object>();
        for (Method method : ProviderHelper.getGetterMethods(provider, sorted)) {
            GetProperty getter = method.getAnnotation(GetProperty.class);
            getterMap.put(getter.name(), ProviderHelper.getValue(method, provider));
        }
        return getterMap;
    }

    public static ArrayList<Method> getGetterMethods(AbstractDataProvider provider, boolean sorted) {
        return ProviderHelper.getMethods(provider, sorted, 0);
    }

    public static ArrayList<Method> getSetterMethods(AbstractDataProvider provider, boolean sorted) {
        return ProviderHelper.getMethods(provider, sorted, 1);
    }

    public static Object getValue(Method method, AbstractDataProvider provider) {
        try {
            return method.invoke((Object)provider, new Object[0]);
        }
        catch (Exception e) {
            ArchieActivator.LOG.log("Could not invoke a method for a provider.\nMethod: " + method.getName() + "\n" + ((Object)((Object)provider)).getClass().getName() + "\n" + e.getLocalizedMessage(), 2);
            return null;
        }
    }

    public static void setValue(AbstractDataProvider provider, Method method, Object value) throws Exception {
        try {
            method.invoke((Object)provider, value);
        }
        catch (Exception e) {
            throw (Exception)e.getCause();
        }
    }

    private static ArrayList<Method> getMethods(AbstractDataProvider provider, boolean sorted, int which) {
        ArrayList<Method> methods = new ArrayList<Method>();
        Method[] methodArray = ((Object)((Object)provider)).getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (which == 0 && method.isAnnotationPresent(GetProperty.class)) {
                methods.add(method);
            } else if (which == 1 && method.isAnnotationPresent(SetProperty.class)) {
                methods.add(method);
            }
            ++n2;
        }
        if (sorted) {
            ProviderHelper.sortMethodList(methods);
        }
        return methods;
    }

    private static void sortMethodList(ArrayList<Method> methodList) {
        Collections.sort(methodList, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                int index1 = 0;
                int index2 = 0;
                if (o1.isAnnotationPresent(GetProperty.class)) {
                    GetProperty anno1 = o1.getAnnotation(GetProperty.class);
                    GetProperty anno2 = o2.getAnnotation(GetProperty.class);
                    index1 = anno1.index();
                    index2 = anno2.index();
                } else {
                    SetProperty anno1 = o1.getAnnotation(SetProperty.class);
                    SetProperty anno2 = o2.getAnnotation(SetProperty.class);
                    index1 = anno1.index();
                    index2 = anno2.index();
                }
                return index1 - index2;
            }
        });
    }
}

