/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.ui.views;

import ch.elexis.core.model.IUser;
import ch.unibe.iam.scg.archie.ArchieActivator;
import ch.unibe.iam.scg.archie.Messages;
import ch.unibe.iam.scg.archie.acl.ArchieACL;
import ch.unibe.iam.scg.archie.ui.GraphicalMessage;
import ch.unibe.iam.scg.archie.ui.ResultPanel;
import jakarta.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class StatisticsView
extends ViewPart {
    public static final String ID = "ch.unibe.iam.scg.archie.ui.views.StatisticsView";
    private Composite container;
    private ResultPanel resultPanel;
    private GraphicalMessage message;

    @Inject
    void activeUser(@Optional IUser user) {
        Display.getDefault().asyncExec(() -> {
            if (user != null) {
                this.clean();
                this.initialize();
            }
        });
    }

    public void createPartControl(Composite parent) {
        this.container = parent;
        this.initialize();
    }

    public void dispose() {
        super.dispose();
    }

    private void initialize() {
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.container.setLayout((Layout)layout);
        this.message = ArchieACL.userHasAccess() ? new GraphicalMessage(this.container, ArchieActivator.getImage("warningt"), Messages.NO_PLUGIN_SELECTED) : new GraphicalMessage(this.container, ArchieActivator.getImage("error"), Messages.ACL_ACCESS_DENIED);
        this.container.layout();
    }

    public void removeInitializeMessage() {
        if (this.message != null) {
            this.message.dispose();
        }
    }

    public void setFocus() {
    }

    public Composite getParent() {
        return this.container;
    }

    public void clean() {
        if (this.container != null && !this.container.isDisposed()) {
            Control[] controlArray = this.container.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.dispose();
                ++n2;
            }
        }
    }

    public void setResultComposite(ResultPanel composite) {
        this.resultPanel = composite;
    }

    public ResultPanel getResultPanel() {
        return this.resultPanel;
    }
}

