/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.tests;

import ch.unibe.iam.scg.archie.model.DataSet;
import java.util.ArrayList;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import org.junit.Before;

public class DataSetTest {
    private DataSet sampleDataSet;
    private DataSet emptyDataSet;
    private ArrayList<String> sampleHeadings = new ArrayList();
    private ArrayList<String> sampleHeadingsTooFew = new ArrayList();
    private ArrayList<Comparable<?>[]> sampleContent = new ArrayList();
    private String[] sampleRow1 = new String[]{"Hans", "Muster", "Superstrasse 1", "Switzerland"};
    private String[] sampleRow2 = new String[]{"Vreni", "M\u00fcller", "Musterstrasse 1", "Switzerland"};
    private String[] sampleRow3 = new String[]{"Jakob", "Meier", "Ottweg 3", "Switzerland"};
    private String[] smallRow = new String[]{"Jakob", "Meier", "Ottweg 3"};

    @Before
    public void setUp() {
        this.sampleHeadings.add("First Name");
        this.sampleHeadings.add("Last Name");
        this.sampleHeadings.add("Address");
        this.sampleHeadings.add("Country");
        this.sampleHeadingsTooFew.add("First Name");
        this.sampleHeadingsTooFew.add("Last Name");
        this.sampleHeadingsTooFew.add("Address");
        this.sampleContent.add((Comparable<?>[])this.sampleRow1);
        this.sampleContent.add((Comparable<?>[])this.sampleRow2);
        this.sampleContent.add((Comparable<?>[])this.sampleRow3);
        this.sampleDataSet = new DataSet(this.sampleContent, this.sampleHeadings);
        this.emptyDataSet = new DataSet();
    }

    @org.junit.Test
    public void testClone() {
        DataSet clonedSet = this.sampleDataSet.clone();
        Assert.assertNotSame((Object)clonedSet, (Object)this.sampleDataSet);
        Assert.assertNotSame(clonedSet.getContent(), this.sampleDataSet.getContent());
        Assert.assertNotSame(clonedSet.getHeadings(), this.sampleDataSet.getHeadings());
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void constructorWithNullAsArguments() {
        new DataSet(null, null);
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void constructorWithEmptyArguments() {
        new DataSet(new ArrayList<Comparable<?>[]>(), new ArrayList<String>());
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void constructorWithTooFewHeaders() {
        new DataSet(this.sampleContent, this.sampleHeadingsTooFew);
    }

    @org.junit.Test
    public void testGetters() {
        Assert.assertEquals(this.sampleContent, this.sampleDataSet.getContent());
        Assert.assertEquals(this.sampleHeadings, this.sampleDataSet.getHeadings());
        Assert.assertArrayEquals((Object[])this.sampleRow1, (Object[])this.sampleDataSet.getRow(0));
        Assert.assertArrayEquals((Object[])this.sampleRow2, (Object[])this.sampleDataSet.getRow(1));
        Assert.assertArrayEquals((Object[])this.sampleRow3, (Object[])this.sampleDataSet.getRow(2));
        Assert.assertEquals((Object)"Hans", this.sampleDataSet.getCell(0, 0));
        Assert.assertEquals((Object)"Meier", this.sampleDataSet.getCell(2, 1));
        Assert.assertEquals((Object)"Vreni", this.sampleDataSet.getCell(1, 0));
        Object[] column1 = new Object[]{"Muster", "M\u00fcller", "Meier"};
        Assert.assertArrayEquals((Object[])column1, (Object[])this.sampleDataSet.getColumn(1));
    }

    @org.junit.Test(expected=IndexOutOfBoundsException.class)
    public void testGetWithEmptyDataSet() {
        this.emptyDataSet.getCell(3, 4);
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void testSetWithEmptyDataSet() {
        this.emptyDataSet.setCell(2, 4, (Comparable<?>)((Object)"Some String"));
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void addTooSmallRowTest() {
        this.sampleDataSet.addRow((Comparable<?>[])this.smallRow);
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void settingContentBeforeHeadings() {
        DataSet dataSet = new DataSet();
        dataSet.setContent(this.sampleContent);
    }

    @org.junit.Test
    public void toStringTest() {
        String desiredOutput = "| First Name | Last Name  | Address         | Country     \n----------------------------------------------------------\n| Hans       | Muster     | Superstrasse 1  | Switzerland \n| Vreni      | M\u00fcller     | Musterstrasse 1 | Switzerland \n| Jakob      | Meier      | Ottweg 3        | Switzerland \n";
        Assert.assertEquals((Object)desiredOutput, (Object)this.sampleDataSet.toString());
    }

    public static Test suite() {
        return new JUnit4TestAdapter(DataSetTest.class);
    }
}

