/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.controller;

import ch.unibe.iam.scg.archie.model.DataSet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;

public class TreeContentProvider
implements ITreeContentProvider {
    private Map<String, List<Comparable<?>[]>> groupedRows = new LinkedHashMap<String, List<Comparable<?>[]>>();
    private DataSet cachedDataSet;
    private List<Comparable<?>[]> flatRows = new ArrayList<Comparable<?>[]>();
    private boolean groupBy;

    public TreeContentProvider(boolean groupBy) {
        this.groupBy = groupBy;
    }

    public Object[] getElements(Object inputElement) {
        if (this.cachedDataSet == null && inputElement instanceof DataSet) {
            this.cachedDataSet = (DataSet)inputElement;
        }
        if (this.groupBy) {
            this.buildGroups();
            return this.groupedRows.keySet().toArray();
        }
        this.buildRows();
        return this.flatRows.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        List<Comparable<?>[]> rows;
        if (parentElement instanceof String && (rows = this.groupedRows.get(parentElement)) != null) {
            return rows.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof String) {
            List<Comparable<?>[]> rows = this.groupedRows.get(element);
            return rows != null && !rows.isEmpty();
        }
        return false;
    }

    private void buildGroups() {
        this.groupedRows.clear();
        String currentGroup = null;
        List<Comparable<?>[]> rows = this.cachedDataSet.getContent();
        for (Comparable<?>[] row : rows) {
            if (row[0] != null && !row[0].toString().isEmpty()) {
                currentGroup = row[0].toString();
                this.groupedRows.put(currentGroup, new ArrayList());
                continue;
            }
            if (currentGroup == null) continue;
            this.groupedRows.get(currentGroup).add(row);
        }
    }

    private void buildRows() {
        this.groupedRows.clear();
        this.flatRows.clear();
        List<Comparable<?>[]> rows = this.cachedDataSet.getContent();
        for (Comparable<?>[] row : rows) {
            this.flatRows.add(row);
        }
    }

    public void refreshDataSet(DataSet newDataSet) {
        this.cachedDataSet = newDataSet;
        if (this.groupBy) {
            this.buildGroups();
        } else {
            this.buildRows();
        }
    }
}

