/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.ui;

import ch.unibe.iam.scg.archie.ArchieActivator;
import ch.unibe.iam.scg.archie.annotations.GetProperty;
import ch.unibe.iam.scg.archie.annotations.SetProperty;
import ch.unibe.iam.scg.archie.model.AbstractDataProvider;
import ch.unibe.iam.scg.archie.model.RegexValidation;
import ch.unibe.iam.scg.archie.ui.widgets.AbstractWidget;
import ch.unibe.iam.scg.archie.ui.widgets.CheckboxWidget;
import ch.unibe.iam.scg.archie.ui.widgets.ComboWidget;
import ch.unibe.iam.scg.archie.ui.widgets.DateWidget;
import ch.unibe.iam.scg.archie.ui.widgets.NumericWidget;
import ch.unibe.iam.scg.archie.ui.widgets.TextWidget;
import ch.unibe.iam.scg.archie.ui.widgets.WidgetTypes;
import ch.unibe.iam.scg.archie.utils.ProviderHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ParametersPanel
extends Composite {
    private Map<String, AbstractWidget> widgetMap;
    private Map<String, Object> defaultValuesMap;
    private AbstractDataProvider provider;

    public ParametersPanel(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
    }

    public void updateParameterList(AbstractDataProvider provider) {
        this.provider = provider;
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.widgetMap = new TreeMap<String, AbstractWidget>();
        this.defaultValuesMap = new HashMap<String, Object>();
        this.createWidgets();
        this.layout();
        this.adjustLabelWidths();
        this.setDefaultValues();
    }

    private void adjustLabelWidths() {
        Label label;
        int maxWidth = 0;
        for (AbstractWidget field : this.widgetMap.values()) {
            label = field.getLabel();
            String labelText = label.getText();
            if (labelText.equals("Leistungen")) continue;
            int width = label.getBounds().width;
            maxWidth = Math.max(width, maxWidth);
        }
        for (AbstractWidget field : this.widgetMap.values()) {
            label = field.getLabel();
            GridData data = new GridData();
            data.widthHint = label.getText().equals("Leistungen") ? 320 : maxWidth;
            label.setLayoutData((Object)data);
        }
        this.layout();
    }

    private void setDefaultValues() {
        for (Map.Entry<String, Object> name : this.defaultValuesMap.entrySet()) {
            this.widgetMap.get(name.getKey()).setValue(name.getValue());
        }
    }

    private void createWidgets() {
        for (Method method : ProviderHelper.getGetterMethods(this.provider, true)) {
            GetProperty getter = method.getAnnotation(GetProperty.class);
            RegexValidation regex = null;
            if (!getter.validationRegex().equals("") && !getter.validationMessage().equals("")) {
                regex = new RegexValidation(getter.validationRegex(), getter.validationMessage());
            }
            AbstractWidget widget = this.createWidget(this, getter.name(), getter.widgetType(), regex, getter.vendorClass());
            if (!getter.description().equals("")) {
                widget.setDescription(getter.description());
            }
            if (getter.items().length > 0 && widget instanceof ComboWidget && getter.widgetType() != WidgetTypes.VENDOR) {
                ((ComboWidget)widget).setItems(getter.items());
            }
            this.widgetMap.put(getter.name(), widget);
            this.defaultValuesMap.put(getter.name(), ProviderHelper.getValue(method, this.provider));
        }
    }

    public void updateProviderParameters() throws Exception {
        this.setProviderData();
    }

    public boolean allFieldsValid() {
        for (Map.Entry<String, AbstractWidget> entry : this.widgetMap.entrySet()) {
            if (entry.getValue().isValid()) continue;
            return false;
        }
        return true;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.widgetMap != null) {
            for (Map.Entry<String, AbstractWidget> entry : this.widgetMap.entrySet()) {
                entry.getValue().setEnabled(enabled);
            }
        }
    }

    private AbstractWidget createWidget(Composite parent, String label, WidgetTypes widgetType, RegexValidation regex, Class<?> vendorClass) {
        switch (widgetType) {
            case TEXT_DATE: {
                return new DateWidget(parent, 0, label, regex);
            }
            case TEXT_NUMERIC: {
                return new NumericWidget(parent, 0, label, regex);
            }
            case BUTTON_CHECKBOX: {
                return new CheckboxWidget(parent, 0, label, regex);
            }
            case COMBO: {
                return new ComboWidget(parent, 0, label, regex);
            }
            case VENDOR: {
                return this.createVendorWidget(parent, label, widgetType, regex, vendorClass);
            }
        }
        return new TextWidget(parent, 0, label, regex);
    }

    private void setProviderData() throws Exception {
        assert (this.provider != null);
        this.setData(ProviderHelper.getSetterMethods(this.provider, true));
    }

    private void setData(ArrayList<Method> setterList) throws Exception {
        for (Method method : setterList) {
            SetProperty setter = method.getAnnotation(SetProperty.class);
            AbstractWidget field = this.widgetMap.get(setter.name());
            Object value = field.getValue();
            ProviderHelper.setValue(this.provider, method, value);
        }
    }

    private AbstractWidget createVendorWidget(Composite parent, String label, WidgetTypes widgetType, RegexValidation regex, Class<?> vendorClass) {
        AbstractWidget widget = null;
        Class<?> abstractWidgetClass = vendorClass;
        try {
            widget = (AbstractWidget)((Object)abstractWidgetClass.getConstructor(Composite.class, Integer.TYPE, String.class, RegexValidation.class).newInstance(parent, 0, label, regex));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        if (widget == null) {
            ArchieActivator.LOG.log("Could not create custom vendor widget. Widget class was: [" + vendorClass.getName() + "]", 1);
        }
        return widget;
    }
}

