/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.ui.charts;

import ch.unibe.iam.scg.archie.ui.charts.AbstractChartComposite;
import ch.unibe.iam.scg.archie.ui.charts.AbstractDatasetCreator;
import ch.unibe.iam.scg.archie.ui.charts.ConsultationMoneyDatasetCreator;
import java.awt.Color;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.eclipse.swt.widgets.Composite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;

public class ConsultationMoneyChart
extends AbstractChartComposite {
    private static final String CHART_TITLE = "Consultation Money";

    public ConsultationMoneyChart(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected JFreeChart initializeChart() {
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)CHART_TITLE, (String)"", (String)"Amount", (XYDataset)((XYDataset)this.creator.getDataset()), (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)new Color(this.parent.getBackground().getRed(), this.parent.getBackground().getGreen(), this.parent.getBackground().getBlue()));
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setDomainGridlinePaint((Paint)Color.lightGray);
        plot.setRangeGridlinePaint((Paint)Color.lightGray);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        XYItemRenderer r = plot.getRenderer();
        if (r instanceof XYLineAndShapeRenderer) {
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)r;
            renderer.setBaseShapesVisible(true);
            renderer.setBaseShapesFilled(true);
            renderer.setDrawSeriesLineAsPath(true);
        }
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("MMM-yyyy"));
        return chart;
    }

    @Override
    protected AbstractDatasetCreator initializeCreator() {
        return new ConsultationMoneyDatasetCreator(CHART_TITLE);
    }

    @Override
    public void refresh() {
        super.refresh();
    }
}

