/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.ui;

import ch.unibe.iam.scg.archie.ArchieActivator;
import ch.unibe.iam.scg.archie.Messages;
import ch.unibe.iam.scg.archie.actions.NewStatisticsAction;
import ch.unibe.iam.scg.archie.controller.ProviderManager;
import ch.unibe.iam.scg.archie.model.AbstractDataProvider;
import ch.unibe.iam.scg.archie.ui.ParametersPanel;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class DetailsPanel
extends Composite
implements Observer {
    private Text description;
    private ParametersPanel parameters;
    private ActionContributionItem startButton;
    private Button cancelButton;
    private NewStatisticsAction action;

    public DetailsPanel(Composite parent, int style) {
        super(parent, style);
        ProviderManager.getInstance().addObserver(this);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 5;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        this.description = new Text((Composite)this, 66);
        this.description.setEditable(false);
        this.description.setLayoutData((Object)new GridData(768));
        this.description.setBackground(parent.getBackground());
        this.parameters = new ParametersPanel(this, 0);
        this.parameters.setLayoutData(new GridData(768));
        Composite buttonContainer = new Composite((Composite)this, 0);
        GridLayout buttonContainerLayout = new GridLayout();
        buttonContainerLayout.numColumns = 2;
        buttonContainerLayout.marginWidth = 0;
        buttonContainerLayout.marginHeight = 0;
        buttonContainer.setLayout((Layout)buttonContainerLayout);
        buttonContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createQueryButton(buttonContainer);
        this.createCancelButton(buttonContainer);
        this.reset();
    }

    private void createQueryButton(Composite parent) {
        this.action = new NewStatisticsAction(this.parameters);
        this.startButton = new ActionContributionItem((IAction)this.action);
        this.startButton.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        this.startButton.fill(parent);
    }

    private void createCancelButton(Composite parent) {
        this.cancelButton = new Button(parent, 0);
        this.cancelButton.setText(Messages.CANCEL);
        this.cancelButton.setImage(ArchieActivator.getImage("cancel"));
        this.cancelButton.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                ProviderManager manager = ProviderManager.getInstance();
                if (manager.hasProvider()) {
                    manager.getProvider().cancel();
                }
            }
        });
    }

    public void reset() {
        this.description.setText(Messages.EMPTY_PROVIDER_DESCRIPTION);
        this.action.setEnabled(false);
        Control[] controlArray = this.parameters.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.layout();
    }

    public void setEnabled(boolean enabled) {
        this.description.setEnabled(enabled);
        this.parameters.setEnabled(enabled);
        this.setCancelButtonEnabled(!enabled);
    }

    public void setCancelButtonEnabled(boolean enabled) {
        this.cancelButton.setEnabled(enabled);
    }

    public void setActionEnabled(boolean enabled) {
        this.action.setEnabled(enabled);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.action.addPropertyChangeListener(listener);
    }

    @Override
    public void update(Observable observable, Object arg) {
        if (ProviderManager.getInstance().hasProvider() && !this.isDisposed()) {
            AbstractDataProvider provider = ProviderManager.getInstance().getProvider();
            this.description.setText(provider.getDescription());
            this.description.pack(true);
            this.parameters.updateParameterList(provider);
            this.layout();
        }
    }
}

