/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.ui.views;

import ch.elexis.core.model.IUser;
import ch.unibe.iam.scg.archie.ArchieActivator;
import ch.unibe.iam.scg.archie.Messages;
import ch.unibe.iam.scg.archie.acl.ArchieACL;
import ch.unibe.iam.scg.archie.controller.ProviderManager;
import ch.unibe.iam.scg.archie.model.AbstractDataProvider;
import ch.unibe.iam.scg.archie.ui.DetailsPanel;
import jakarta.inject.Inject;
import java.util.TreeMap;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class SidebarView
extends ViewPart
implements IPropertyChangeListener {
    public static final String ID = "ch.unibe.iam.scg.archie.ui.views.StatisticsSidebarView";
    protected Combo list;
    protected DetailsPanel details;
    protected AutoCompleteField autoComplete;

    @Inject
    void activeUser(@Optional IUser user) {
        Display.getDefault().asyncExec(() -> {
            if (user != null) {
                boolean accessEnabled = ArchieACL.userHasAccess();
                this.setEnabled(accessEnabled);
                if (!accessEnabled) {
                    this.details.setCancelButtonEnabled(accessEnabled);
                    this.details.setActionEnabled(accessEnabled);
                } else if (this.list.getSelectionIndex() != -1) {
                    this.details.setActionEnabled(accessEnabled);
                }
                if (ProviderManager.getInstance().hasProvider()) {
                    ProviderManager.getInstance().getProvider().cancel();
                }
            }
        });
    }

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        Group availableStatistics = new Group(container, 0);
        availableStatistics.setLayoutData((Object)new GridData(768));
        availableStatistics.setLayout((Layout)layout);
        availableStatistics.setText(Messages.STATISTICS_LIST_TITLE);
        TreeMap<String, AbstractDataProvider> providers = ArchieActivator.getInstance().getProviderTable();
        String[] availableTitles = providers.keySet().toArray(new String[providers.size()]);
        this.list = new Combo((Composite)availableStatistics, 2052);
        this.list.setLayoutData((Object)new GridData(768));
        this.autoComplete = new AutoCompleteField((Control)this.list, (IControlContentAdapter)new ComboContentAdapter(), availableTitles);
        this.list.setItems(availableTitles);
        this.list.setVisibleItemCount(5);
        this.list.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String title = SidebarView.this.list.getText();
                if (SidebarView.this.isValidProviderTitle(title)) {
                    AbstractDataProvider provider = ArchieActivator.getInstance().getProviderTable().get(title);
                    ProviderManager.getInstance().setProvider(provider);
                } else {
                    SidebarView.this.details.reset();
                }
            }
        });
        Group statisticParameters = new Group(container, 0);
        statisticParameters.setLayoutData((Object)new GridData(1808));
        statisticParameters.setLayout((Layout)layout);
        statisticParameters.setText(Messages.STATISTIC_PARAMETERS_TITLE);
        this.details = new DetailsPanel((Composite)statisticParameters, 0);
        this.details.addPropertyChangeListener(this);
        this.setEnabled(ArchieACL.userHasAccess());
    }

    protected boolean isValidProviderTitle(String title) {
        return ArchieActivator.getInstance().getProviderTable().get(title) != null;
    }

    public void setFocus() {
    }

    public void setEnabled(boolean enabled) {
        if (this.list != null && this.details != null) {
            this.list.setEnabled(enabled);
            this.details.setEnabled(enabled);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("JOB_RUNNING")) {
            this.setEnabled(false);
        }
        if (event.getProperty().equals("JOB_DONE")) {
            this.setEnabled(true);
        }
    }

    public void dispose() {
        ProviderManager.getInstance().setProvider(null);
        super.dispose();
    }
}

