/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.model;

import ch.unibe.iam.scg.archie.model.DataSet;
import ch.unibe.iam.scg.archie.utils.ArrayUtils;

public class ChartModel {
    public static final int CHART_PIE = 1;
    public static final int CHART_BAR = 2;
    private boolean isLineChart = false;
    private String chartName = null;
    private DataSet dataSet = null;
    private int[] rows = null;
    private int[] columns = null;
    private int keysIndex = -1;
    private int valuesIndex = -1;
    private int categoryColumnIndex = 0;
    private int chartType = -1;
    private boolean isThreeDimensional = false;

    public void setChartType(int chartType) {
        this.chartType = chartType;
    }

    public int getChartType() {
        return this.chartType;
    }

    public String getChartName() {
        return this.chartName;
    }

    public void setChartName(String chartName) {
        this.chartName = chartName;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public boolean hasDataSet() {
        return this.dataSet != null;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public int getKeysIndex() {
        return this.keysIndex;
    }

    public void setKeysIndex(int keysIndex) {
        this.keysIndex = keysIndex;
    }

    public int getValuesIndex() {
        return this.valuesIndex;
    }

    public void setValuesIndex(int valuesIndex) {
        this.valuesIndex = valuesIndex;
    }

    public void setRows(int[] rows) {
        this.rows = rows;
    }

    public int[] getRows() {
        return this.rows;
    }

    public void setColumns(int[] columns) {
        this.columns = columns;
    }

    public int[] getColumns() {
        return this.columns;
    }

    public boolean isThreeDimensional() {
        return this.isThreeDimensional;
    }

    public void setThreeDimensional(boolean isThreeDimensional) {
        this.isThreeDimensional = isThreeDimensional;
    }

    public void setCategoryColumnIndex(int columnIndex) {
        this.categoryColumnIndex = columnIndex;
    }

    public int getCategoryColumnIndex() {
        return this.categoryColumnIndex;
    }

    public void setLineChart(boolean isLineChart) {
        this.isLineChart = isLineChart;
    }

    public boolean isLineChart() {
        return this.chartType == 2 && this.isLineChart;
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        output.append("********************************************************************************\n");
        output.append("Type: " + this.chartType + "\n");
        output.append("Name: " + this.chartName + "\n");
        output.append("Keys Index: " + this.keysIndex + "\n");
        output.append("Values Index: " + this.valuesIndex + "\n");
        output.append("Rows: " + ArrayUtils.toString(this.rows) + "\n");
        output.append("Columns: " + ArrayUtils.toString(this.columns) + "\n");
        output.append("Category Column Index: " + this.categoryColumnIndex + "\n");
        output.append("Line Chart: " + this.isLineChart + "\n");
        output.append("3D: " + this.isThreeDimensional + "\n");
        output.append("Dataset:\n\n" + this.dataSet.toString());
        output.append("********************************************************************************\n");
        return output.toString();
    }

    public boolean isValid() {
        return this.hasValidChartType() && (this.isValidPieChart() || this.isValidBarChart() || this.isValidLineChart());
    }

    private boolean isValidPieChart() {
        return this.chartName != null && this.dataSet != null && this.chartType == 1 && this.keysIndex != -1 && this.valuesIndex != -1 && this.rows != null && this.rows.length > 0;
    }

    private boolean isValidBarChart() {
        return this.chartName != null && this.dataSet != null && this.chartType == 2 && this.categoryColumnIndex >= 0 && this.columns != null && this.columns.length > 0 && this.rows != null && this.rows.length > 0 && !this.isLineChart;
    }

    private boolean isValidLineChart() {
        return this.chartName != null && this.dataSet != null && this.chartType == 2 && this.categoryColumnIndex >= 0 && this.columns != null && this.columns.length > 0 && this.rows != null && this.rows.length > 0 && this.isLineChart;
    }

    public boolean hasValidChartType() {
        return this.chartType == 2 || this.chartType == 1;
    }
}

