/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.ui.charts;

import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.unibe.iam.scg.archie.model.Cohort;
import ch.unibe.iam.scg.archie.ui.charts.AbstractDatasetCreator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jfree.data.general.DefaultKeyedValues2DDataset;

public class PatientsConsHistDatasetCreator
extends AbstractDatasetCreator {
    private static final int MALE_INDEX = 0;
    private static final int FEMALE_INDEX = 1;
    private int cohortSize;
    private boolean isEmpty;

    public PatientsConsHistDatasetCreator(String jobName, int cohortSize) {
        super(jobName);
        this.setCohortSize(cohortSize);
        this.isEmpty = true;
    }

    @Override
    public IStatus createContent(IProgressMonitor monitor) {
        this.dataset = new DefaultKeyedValues2DDataset();
        Query query = new Query(Patient.class);
        List patients = query.execute();
        this.isEmpty = patients.size() <= 0;
        monitor.beginTask("Querying Database...", patients.size());
        TreeMap<Cohort, Cohort> histogramm = new TreeMap<Cohort, Cohort>();
        for (Patient patient : patients) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            int age = 0;
            try {
                age = Integer.parseInt(patient.getAlter());
            }
            catch (NumberFormatException exception) {
                continue;
            }
            Double consCostsPerPatient = new Double(0.0);
            Fall[] fallArray = patient.getFaelle();
            int n = fallArray.length;
            int n2 = 0;
            while (n2 < n) {
                Fall fall = fallArray[n2];
                Konsultation[] konsultationArray = fall.getBehandlungen(false);
                int n3 = konsultationArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Konsultation konsultation = konsultationArray[n4];
                    consCostsPerPatient = consCostsPerPatient + (double)(konsultation.getKosten() / 100);
                    ++n4;
                }
                ++n2;
            }
            String gender = patient.getGeschlecht();
            if (!gender.equals("m") && !gender.equals("w")) continue;
            int lowerBound = age / this.cohortSize * this.cohortSize;
            int upperBound = lowerBound + (this.cohortSize - 1);
            Double[] consultationGenderCosts = new Double[2];
            Cohort cohort = new Cohort(lowerBound, upperBound, consultationGenderCosts);
            if (!histogramm.containsKey(cohort)) {
                if (gender.equals("m")) {
                    consultationGenderCosts[0] = consCostsPerPatient;
                    consultationGenderCosts[1] = 0.0;
                    histogramm.put(cohort, cohort);
                } else {
                    consultationGenderCosts[0] = 0.0;
                    consultationGenderCosts[1] = -consCostsPerPatient.doubleValue();
                    histogramm.put(cohort, cohort);
                }
            } else if (gender.equals("m")) {
                Double[] genderCountTmp = (Double[])((Cohort)histogramm.get(cohort)).getValue();
                genderCountTmp[0] = genderCountTmp[0] - consCostsPerPatient;
            } else {
                Double[] genderCountTmp = (Double[])((Cohort)histogramm.get(cohort)).getValue();
                genderCountTmp[1] = genderCountTmp[1] + consCostsPerPatient;
            }
            monitor.worked(1);
        }
        for (Map.Entry entry : histogramm.entrySet()) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Double[] ConsCosts = new Double[2];
            ConsCosts = (Double[])((Cohort)entry.getValue()).getValue();
            ((DefaultKeyedValues2DDataset)this.dataset).addValue((Number)ConsCosts[0], (Comparable)((Object)"Male"), (Comparable)entry.getKey());
            ((DefaultKeyedValues2DDataset)this.dataset).addValue((Number)ConsCosts[1], (Comparable)((Object)"Female"), (Comparable)entry.getKey());
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    public void setCohortSize(int cohortSize) {
        this.cohortSize = cohortSize;
    }

    @Override
    protected boolean isDatasetEmpty() {
        return this.isEmpty;
    }
}

