/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DataSet
implements Iterable<Comparable<?>[]>,
Cloneable {
    private List<Comparable<?>[]> content;
    private List<String> headings;
    private int width = 0;

    public DataSet() {
        this.content = new ArrayList<Comparable<?>[]>();
        this.headings = new ArrayList<String>();
    }

    public DataSet(List<Comparable<?>[]> content, List<String> headings) throws IllegalArgumentException {
        if (content == null || headings == null || content.isEmpty() || headings.isEmpty()) {
            throw new IllegalArgumentException("Argument lists and headings must not be null and not empty!");
        }
        if (content.get(0).length != headings.size()) {
            throw new IllegalArgumentException("Number of columns has to match provided number of headings!");
        }
        this.content = content;
        this.headings = headings;
        this.width = this.content.get(0).length;
    }

    public void setCell(int x, int y, Comparable<?> value) {
        if (x > this.content.size() || y > this.content.get(x).length - 1) {
            throw new IllegalArgumentException("Your trying to update a dataset element at a position that is greater than the dataset's boundaries.");
        }
        this.content.get((int)x)[y] = value;
    }

    public Comparable<?> getCell(int x, int y) {
        return this.content.get(x)[y];
    }

    public Comparable<?>[] getRow(int x) {
        return this.content.get(x);
    }

    public void setRow(int x, Comparable<?>[] obj) {
        if (x > this.content.size()) {
            throw new IllegalArgumentException("Your trying to access a row in the dataset that is greater than the dataset's boundaries.");
        }
        this.content.set(x, obj);
    }

    public Comparable<?>[] getColumn(int y) {
        ArrayList column = new ArrayList(this.content.size());
        for (Comparable<?>[] objects : this.content) {
            column.add(objects[y]);
        }
        return column.toArray(new Comparable[column.size()]);
    }

    public void addRow(Comparable<?>[] row) {
        if (row.length != this.width) {
            throw new IllegalArgumentException("The number of columns of a row being added to the dataset hat so equal the number of columns in the dataset.");
        }
        this.content.add(row);
    }

    @Override
    public Iterator<Comparable<?>[]> iterator() {
        return this.content.iterator();
    }

    public List<Comparable<?>[]> getContent() {
        return this.content;
    }

    public void setContent(List<Comparable<?>[]> content) {
        if (content == null) {
            throw new IllegalArgumentException("Content of a dataset can not be null!");
        }
        if (this.headings.isEmpty()) {
            throw new IllegalArgumentException("Can not set content before headings are set, also headings can not be empty!");
        }
        if (!content.isEmpty() && content.get(0).length != this.headings.size()) {
            throw new IllegalArgumentException("Provided number of content does not match the number of headings!");
        }
        this.content = content;
        this.width = this.headings.size();
    }

    public List<String> getHeadings() {
        return this.headings;
    }

    public void setHeadings(List<String> headings) {
        if (headings == null || headings.isEmpty()) {
            throw new IllegalArgumentException("Provided table headings can not be null or empty!");
        }
        this.headings = headings;
    }

    public String toString() {
        int[] columnWidths = new int[this.headings.size()];
        int totalWidth = 0;
        int i = 0;
        while (i < columnWidths.length) {
            Comparable<?>[] column;
            for (String heading : this.headings) {
                if (heading.toString().length() <= columnWidths[i]) continue;
                columnWidths[i] = heading.toString().length();
            }
            Comparable<?>[] comparableArray = column = this.getColumn(i);
            int n = column.length;
            int n2 = 0;
            while (n2 < n) {
                Comparable<?> length = comparableArray[n2];
                if (length.toString().length() > columnWidths[i]) {
                    columnWidths[i] = length.toString().length();
                }
                ++n2;
            }
            ++i;
        }
        int[] nArray = columnWidths;
        int length = columnWidths.length;
        int column = 0;
        while (column < length) {
            int width = nArray[column];
            totalWidth += width;
            ++column;
        }
        StringBuilder output = new StringBuilder();
        int i2 = 0;
        while (i2 < this.headings.size()) {
            String heading = this.headings.get(i2);
            output.append("| ");
            output.append(heading);
            if (heading.length() < columnWidths[i2]) {
                int difference = columnWidths[i2] - heading.length();
                int j = 0;
                while (j < difference) {
                    output.append(" ");
                    ++j;
                }
            }
            output.append(" ");
            ++i2;
        }
        output.append("\n");
        i2 = 0;
        while (i2 < totalWidth) {
            output.append("-");
            ++i2;
        }
        i2 = 0;
        while (i2 < this.headings.size()) {
            output.append("---");
            ++i2;
        }
        output.append("\n");
        int x = 0;
        while (x < this.content.size()) {
            Comparable<?>[] row = this.getRow(x);
            int y = 0;
            while (y < row.length) {
                String cellValue = this.getCell(x, y).toString();
                output.append("| ");
                output.append(cellValue);
                if (cellValue.length() < columnWidths[y]) {
                    int difference = columnWidths[y] - cellValue.length();
                    int j = 0;
                    while (j < difference) {
                        output.append(" ");
                        ++j;
                    }
                }
                output.append(" ");
                ++y;
            }
            output.append("\n");
            ++x;
        }
        return output.toString();
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public DataSet clone() {
        DataSet cloneSet = null;
        try {
            cloneSet = (DataSet)super.clone();
            cloneSet.content = new ArrayList<Comparable<?>[]>(cloneSet.content);
            cloneSet.headings = new ArrayList<String>(cloneSet.headings);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return cloneSet;
    }
}

