/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.controller;

import ch.unibe.iam.scg.archie.controller.TreeContentProvider;
import ch.unibe.iam.scg.archie.controller.TreeLabelProvider;
import ch.unibe.iam.scg.archie.model.AbstractDataProvider;
import ch.unibe.iam.scg.archie.model.DataSet;
import ch.unibe.iam.scg.archie.model.TreeViewerComparator;
import java.util.List;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class TreeFactory {
    private static TreeFactory INSTANCE = null;

    private TreeFactory() {
    }

    public static final TreeFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TreeFactory();
        }
        return INSTANCE;
    }

    public TreeViewer createTreeFromData(Composite parent, DataSet dataset, AbstractDataProvider provider, boolean groupBy) {
        int startIndex;
        Tree tree = new Tree(parent, 66306);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeColumnLayout treeLayout = new TreeColumnLayout();
        parent.setLayout((Layout)treeLayout);
        this.createTreeColumns(tree, treeLayout, dataset.getHeadings(), groupBy);
        final TreeViewer treeViewer = new TreeViewer(tree);
        if (provider.isTree() && provider.getTreeContentProvider() != null) {
            treeViewer.setContentProvider((IContentProvider)provider.getTreeContentProvider());
        } else {
            TreeContentProvider defaultProvider = new TreeContentProvider(groupBy);
            defaultProvider.refreshDataSet(dataset);
            treeViewer.setContentProvider((IContentProvider)defaultProvider);
        }
        ILabelProvider labelProvider = provider.getLabelProvider();
        treeViewer.setLabelProvider((IBaseLabelProvider)(labelProvider != null ? labelProvider : new TreeLabelProvider(groupBy)));
        final TreeViewerComparator comparator = new TreeViewerComparator();
        treeViewer.setComparator((ViewerComparator)comparator);
        treeViewer.setInput((Object)dataset);
        TreeColumn[] cols = treeViewer.getTree().getColumns();
        int i = startIndex = groupBy ? 1 : 0;
        while (i < cols.length) {
            final TreeColumn tc = cols[i];
            final int index = i - startIndex;
            tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TreePath[] expandedPaths = treeViewer.getExpandedTreePaths();
                    comparator.setColumn(index);
                    treeViewer.getTree().setSortDirection(comparator.getDirection());
                    treeViewer.getTree().setSortColumn(tc);
                    treeViewer.refresh();
                    treeViewer.setExpandedTreePaths(expandedPaths);
                }
            });
            ++i;
        }
        return treeViewer;
    }

    private void createTreeColumns(Tree tree, TreeColumnLayout treeLayout, List<String> headings, boolean groupBy) {
        if (groupBy) {
            TreeColumn arrowColumn = new TreeColumn(tree, 0);
            arrowColumn.setText("");
            arrowColumn.setWidth(30);
            arrowColumn.setResizable(false);
            treeLayout.setColumnData((Widget)arrowColumn, (ColumnLayoutData)new ColumnPixelData(30, false));
        }
        int i = 0;
        while (i < headings.size()) {
            TreeColumn column = new TreeColumn(tree, 0);
            column.setText(headings.get(i));
            column.setMoveable(true);
            if (i == 0) {
                treeLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(0, 300, true));
            } else if (i == 1) {
                treeLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(0, 100, true));
            } else {
                treeLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1));
            }
            ++i;
        }
    }
}

