/*
 * Decompiled with CFR 0.152.
 */
package ch.pharmed.phmprescriber;

import ch.elexis.data.Artikel;
import ch.elexis.data.Patient;
import ch.elexis.data.Prescription;
import ch.elexis.data.Rezept;
import ch.pharmed.phmprescriber.Physician;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

class Pagecounter
implements Printable {
    private static Font fnt = new Font("Helvetica", 0, 8);
    private static Font fntBold = new Font("Helvetica", 1, 8);
    private static Font fntTitle = new Font("Helvetica", 1, 11);
    private final double LMARGINRATIO = 0.3;
    private final double SPACERATIO = 1.5;
    int Code128Width = 185;
    int Code128Height = 36;
    int QRCodeBorder = 118;
    private Physician ph;
    private Rezept rp;
    private Patient pat;
    List<Integer> indices = new ArrayList<Integer>();

    public List<Integer> getIndices() {
        return this.indices;
    }

    public void setIndices(List<Integer> indices) {
        this.indices = indices;
    }

    public Pagecounter(Physician ph, Rezept rp, String presID, String QRCode) {
        this.ph = ph;
        this.rp = rp;
        this.pat = rp.getPatient();
        this.indices.add(-1);
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int page) throws PrinterException {
        double printAreaX = pageFormat.getImageableX();
        double printAreaY = pageFormat.getImageableY();
        FontMetrics metrics = g.getFontMetrics(fnt);
        int intMeasureY = 0;
        int intMarginLeft = (int)Math.round(printAreaX * 0.3);
        int intSpace = (int)Math.round((double)metrics.getHeight() * 1.5);
        int intDefaultHeight = metrics.getHeight();
        int intPageWidth = (int)Math.round(pageFormat.getImageableWidth());
        int pageHeight = (int)Math.round(pageFormat.getImageableHeight());
        metrics = g.getFontMetrics(fntTitle);
        int intSpaceBig = metrics.getHeight();
        g.setColor(Color.black);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.black);
        g2d.translate(printAreaX, printAreaY);
        g.setFont(fntBold);
        metrics = g.getFontMetrics(fntBold);
        intMeasureY += metrics.getHeight();
        g.setFont(fnt);
        metrics = g.getFontMetrics(fnt);
        intMeasureY += metrics.getHeight();
        if (this.ph.getSpecialty2().length() > 0) {
            intMeasureY += intDefaultHeight;
        }
        intMeasureY += intSpace;
        intMeasureY += intDefaultHeight;
        intMeasureY += intSpace;
        if (this.ph.getFax().length() > 0) {
            intMeasureY += intDefaultHeight;
        }
        intMeasureY += intSpace;
        if (this.ph.getGlnid().length() > 0) {
            intMeasureY += intDefaultHeight;
        }
        intMeasureY += intSpaceBig;
        intMeasureY += intSpaceBig + intSpace;
        g.setFont(fntTitle);
        intMeasureY += intSpaceBig + intDefaultHeight;
        g.setFont(fntBold);
        metrics = g.getFontMetrics(fntBold);
        g.setFont(fnt);
        int upperlimit = intMeasureY += intSpaceBig + intSpace;
        int lowerLimit = pageHeight - this.QRCodeBorder - intSpaceBig * 2;
        int areaHeight = lowerLimit - upperlimit;
        intMeasureY = 0;
        Hashtable hash = new Hashtable();
        int i = 0;
        while (i < this.rp.getLines().size()) {
            Prescription actualLine = (Prescription)this.rp.getLines().get(i);
            Artikel article = actualLine.getArtikel();
            AttributedString attributedString = new AttributedString("1x " + article.getLabel(), hash);
            attributedString.addAttribute(TextAttribute.FONT, fntBold);
            g2d.setFont(fntBold);
            FontRenderContext frc = g2d.getFontRenderContext();
            AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
            int intstart = attributedCharacterIterator.getBeginIndex();
            int intend = attributedCharacterIterator.getEndIndex();
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, frc);
            float width = (float)intPageWidth - (float)intMarginLeft;
            lineBreakMeasurer.setPosition(intstart);
            while (lineBreakMeasurer.getPosition() < intend) {
                TextLayout textLayout = lineBreakMeasurer.nextLayout(width);
                intMeasureY = (int)((float)intMeasureY + textLayout.getAscent());
                intMeasureY = (int)((float)intMeasureY + (textLayout.getDescent() + textLayout.getLeading()));
            }
            Object label = actualLine.getBemerkung();
            if (actualLine.getDosis().length() > 0) {
                label = actualLine.getDosis() + ", " + (String)label;
            }
            if (((String)label).length() == 0) {
                if (areaHeight < intMeasureY) {
                    this.indices.add(i - 1);
                    --i;
                    intMeasureY = 0;
                } else {
                    intMeasureY += intSpaceBig * 2;
                }
            } else {
                attributedString = new AttributedString((String)label, hash);
                attributedString.addAttribute(TextAttribute.FONT, fnt);
                g2d.setFont(fnt);
                frc = g2d.getFontRenderContext();
                attributedCharacterIterator = attributedString.getIterator();
                intstart = attributedCharacterIterator.getBeginIndex();
                intend = attributedCharacterIterator.getEndIndex();
                lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, frc);
                lineBreakMeasurer.setPosition(intstart);
                while (lineBreakMeasurer.getPosition() < intend) {
                    int next = lineBreakMeasurer.nextOffset(width);
                    int limit = next;
                    if (limit <= ((String)label).length()) {
                        int k = lineBreakMeasurer.getPosition();
                        while (k < next) {
                            char c = ((String)label).charAt(k);
                            if (c == '\n') {
                                limit = k + 1;
                                break;
                            }
                            ++k;
                        }
                    }
                    TextLayout textLayout = lineBreakMeasurer.nextLayout(width, limit, false);
                    intMeasureY = (int)((float)intMeasureY + textLayout.getAscent());
                    intMeasureY = (int)((float)intMeasureY + (textLayout.getDescent() + textLayout.getLeading()));
                }
                if (areaHeight < intMeasureY) {
                    this.indices.add(i - 1);
                    --i;
                    intMeasureY = 0;
                } else {
                    intMeasureY += intSpaceBig * 2;
                }
            }
            ++i;
        }
        this.indices.add(this.rp.getLines().size() - 1);
        return 1;
    }
}

