/*
 * Decompiled with CFR 0.152.
 */
package ch.novcom.elexis.mednet.plugin.ui.dialog;

import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.WidgetFactory;
import ch.elexis.core.ui.views.controls.KontaktSelectionComposite;
import ch.elexis.data.Kontakt;
import ch.novcom.elexis.mednet.plugin.MedNet;
import ch.novcom.elexis.mednet.plugin.data.ContactLinkRecord;
import ch.novcom.elexis.mednet.plugin.messages.MedNetMessages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ContactLinkRecordEditDialog
extends TitleAreaDialog {
    private KontaktSelectionComposite contactSelection;
    private Combo mednetIDSelection;
    private List<MedNetItem> mednetItems;
    private Text category_doc;
    private Text category_form;
    private Button docImport_isActive;
    private Text docImport_Id;
    private Button formImport_isActive;
    private Text xidDomain;
    private ContactLinkRecord record;

    public ContactLinkRecordEditDialog(Shell parentShell, ContactLinkRecord record) {
        super(parentShell);
        this.record = record;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(MedNetMessages.ContactLinkRecordEditDialog_shellTitle);
        this.setTitle(MedNetMessages.ContactLinkRecordEditDialog_title);
        this.setMessage(MedNetMessages.ContactLinkRecordEditDialog_message);
        Composite result = new Composite(parent, 0);
        result.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        result.setLayout((Layout)new GridLayout(3, false));
        WidgetFactory.createLabel((Composite)result, (String)MedNetMessages.ContactLinkRecordEditDialog_labelMedNet);
        this.mednetIDSelection = new Combo(result, 8);
        this.mednetIDSelection.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        this.mednetItems = new ArrayList<MedNetItem>();
        for (Map.Entry<String, String> mednetEntry : MedNet.getSettings().getInstitutions().entrySet()) {
            this.mednetItems.add(new MedNetItem(mednetEntry.getKey(), mednetEntry.getValue()));
        }
        Collections.sort(this.mednetItems);
        String[] textList = new String[this.mednetItems.size()];
        int i = 0;
        while (i < this.mednetItems.size()) {
            textList[i] = this.mednetItems.get(i).getName();
            ++i;
        }
        this.mednetIDSelection.setItems(textList);
        WidgetFactory.createLabel((Composite)result, (String)MedNetMessages.ContactLinkRecordEditDialog_labelContact);
        this.contactSelection = new KontaktSelectionComposite(result, 0);
        this.contactSelection.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        Label docSeparator = new Label(result, 258);
        docSeparator.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        Label docLabel = new Label(result, 16384);
        FontDescriptor docBoldDescriptor = FontDescriptor.createFrom((Font)docLabel.getFont()).setStyle(1);
        Font docBoldFont = docBoldDescriptor.createFont((Device)docLabel.getDisplay());
        docLabel.setFont(docBoldFont);
        docLabel.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        docLabel.setText(MedNetMessages.ContactLinkRecordEditDialog_labelDoc);
        WidgetFactory.createLabel((Composite)result, (String)MedNetMessages.ContactLinkRecordEditDialog_labelImportIsActive);
        this.docImport_isActive = new Button(result, 32);
        this.docImport_isActive.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        WidgetFactory.createLabel((Composite)result, (String)MedNetMessages.ContactLinkRecordEditDialog_labelCategory);
        this.category_doc = new Text(result, 2048);
        this.category_doc.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        this.category_doc.setTextLimit(80);
        WidgetFactory.createLabel((Composite)result, (String)MedNetMessages.ContactLinkRecordEditDialog_labelDocImportId);
        this.docImport_Id = new Text(result, 2048);
        this.docImport_Id.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        this.docImport_Id.setTextLimit(80);
        Label formSeparator = new Label(result, 258);
        formSeparator.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        Label formLabel = new Label(result, 16384);
        FontDescriptor formBoldDescriptor = FontDescriptor.createFrom((Font)formLabel.getFont()).setStyle(1);
        Font formBoldFont = formBoldDescriptor.createFont((Device)formLabel.getDisplay());
        formLabel.setFont(formBoldFont);
        formLabel.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        formLabel.setText(MedNetMessages.ContactLinkRecordEditDialog_labelForm);
        WidgetFactory.createLabel((Composite)result, (String)MedNetMessages.ContactLinkRecordEditDialog_labelImportIsActive);
        this.formImport_isActive = new Button(result, 32);
        this.formImport_isActive.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        WidgetFactory.createLabel((Composite)result, (String)MedNetMessages.ContactLinkRecordEditDialog_labelCategory);
        this.category_form = new Text(result, 2048);
        this.category_form.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        this.category_form.setTextLimit(80);
        Label xidSeparator = new Label(result, 258);
        xidSeparator.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        Label xidLabel = new Label(result, 16384);
        FontDescriptor xidBoldDescriptor = FontDescriptor.createFrom((Font)xidLabel.getFont()).setStyle(1);
        Font xidBoldFont = xidBoldDescriptor.createFont((Device)xidLabel.getDisplay());
        xidLabel.setFont(xidBoldFont);
        xidLabel.setText(MedNetMessages.ContactLinkRecordEditDialog_labelXIDDomain);
        this.xidDomain = new Text(result, 2048);
        this.xidDomain.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.xidDomain.setTextLimit(80);
        this.xidDomain.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Text text = (Text)e.getSource();
                String oldS = text.getText();
                String newS = oldS.substring(0, e.start) + e.text + oldS.substring(e.end);
                if (newS.matches(".*[;#].*")) {
                    e.doit = false;
                }
            }
        });
        if (this.record != null) {
            Kontakt contact = Kontakt.load((String)this.record.getContactID());
            this.contactSelection.setKontakt(contact);
            int i2 = 0;
            while (i2 < this.mednetItems.size()) {
                if (this.mednetItems.get(i2).getId().equals(this.record.getMedNetID())) {
                    this.mednetIDSelection.select(i2);
                    break;
                }
                ++i2;
            }
            this.category_doc.setText(this.record.getCategoryDoc());
            this.category_form.setText(this.record.getCategoryForm());
            this.docImport_isActive.setSelection(this.record.docImport_isActive());
            this.docImport_Id.setText(this.record.getDocImport_id());
            this.formImport_isActive.setSelection(this.record.formImport_isActive());
            this.xidDomain.setText(String.valueOf(this.record.getXIDDomain()));
        } else {
            this.mednetIDSelection.deselectAll();
            this.category_doc.setText("");
            this.category_form.setText("");
            this.docImport_isActive.setSelection(true);
            this.docImport_Id.setText("");
            this.formImport_isActive.setSelection(true);
            this.xidDomain.setText("");
        }
        return result;
    }

    protected void okPressed() {
        if (this.contactSelection.getKontakt() == null) {
            this.setErrorMessage(MedNetMessages.ContactLinkRecordEditDialog_NoContact);
            return;
        }
        if (this.mednetIDSelection.getSelectionIndex() < 0) {
            this.setErrorMessage(MedNetMessages.ContactLinkRecordEditDialog_NoMedNet);
            return;
        }
        if (this.record == null) {
            this.record = new ContactLinkRecord(this.contactSelection.getKontakt().getId(), this.mednetItems.get(this.mednetIDSelection.getSelectionIndex()).getId(), this.category_doc.getText(), this.category_form.getText(), this.docImport_isActive.getSelection(), this.docImport_Id.getText(), this.formImport_isActive.getSelection(), this.xidDomain.getText());
        } else {
            this.record.set(new String[]{"ContactID", "MedNetID", "category_doc", "category_form", "docImport_isActive", "docImport_id", "formImport_isActive", "xid_domain"}, new String[]{this.contactSelection.getKontakt().getId(), this.mednetItems.get(this.mednetIDSelection.getSelectionIndex()).getId(), this.category_doc.getText(), this.category_form.getText(), this.docImport_isActive.getSelection() ? "1" : "0", this.docImport_Id.getText(), this.formImport_isActive.getSelection() ? "1" : "0", this.xidDomain.getText()});
        }
        super.okPressed();
    }

    public void setInstitutionIdText(String id) {
        this.contactSelection.setKontakt(Kontakt.load((String)id));
    }

    public void setCategoryDoc(String string) {
        this.category_doc.setText(string);
    }

    public void setCategoryForm(String string) {
        this.category_form.setText(string);
    }

    public void setDocImportId(String string) {
        this.docImport_Id.setText(string);
    }

    public void setXIDDomainText(String string) {
        this.xidDomain.setText(string);
    }

    public static class MedNetItem
    implements Comparable<MedNetItem> {
        private String id;
        private String name;
        boolean isSelected;

        public MedNetItem(String id, String name) {
            this.id = id;
            this.name = name;
            this.setSelected(false);
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }

        @Override
        public int compareTo(MedNetItem other) {
            if (other == null) {
                return -1;
            }
            if (this.getName() != null && other.getName() == null) {
                return -1;
            }
            if (this.getName() == null && other.getName() != null) {
                return 1;
            }
            int comparator = this.getName().compareTo(other.getName());
            if (comparator != 0) {
                return comparator;
            }
            if (this.getId() != null && other.getId() == null) {
                return -1;
            }
            if (this.getId() == null && other.getId() != null) {
                return 1;
            }
            comparator = this.getId().compareTo(other.getId());
            if (comparator != 0) {
                return comparator;
            }
            return 0;
        }
    }
}

