/*
 * Decompiled with CFR 0.152.
 */
package ch.novcom.elexis.mednet.plugin;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MedNetConfigFormItem
implements Comparable<MedNetConfigFormItem> {
    private static final Pattern csvLinePattern = Pattern.compile("^\"(?<accountID>[^\"]*)\";\"(?<accountTitle>[^\"]*)\";\"(?<accountLastname>[^\"]*)\";\"(?<accountFirstname>[^\"]*)\";\"(?<institutionID>[^\"]*)\";\"(?<institutionName>[^\"]*)\";\"(?<formID>[^\"]*)\";\"(?<formName>[^\"]*)\"$");
    private String accountID = "";
    private String accountTitle = "";
    private String accountLastname = "";
    private String accountFirstname = "";
    private String institutionID = "";
    private String institutionName = "";
    private String formID = "";
    private String formName = "";

    public MedNetConfigFormItem(String line) {
        Matcher matcher = csvLinePattern.matcher(line);
        if (matcher.matches()) {
            this.accountID = matcher.group("accountID");
            this.accountTitle = matcher.group("accountTitle");
            this.accountLastname = matcher.group("accountLastname");
            this.accountFirstname = matcher.group("accountFirstname");
            this.institutionID = matcher.group("institutionID");
            this.institutionName = matcher.group("institutionName");
            this.formID = matcher.group("formID");
            this.formName = matcher.group("formName");
        }
    }

    public String getKey() {
        return this.accountID + "_" + this.institutionID + "_" + this.formID;
    }

    public String getAccountID() {
        return this.accountID;
    }

    public String getAccountTitle() {
        return this.accountTitle;
    }

    public String getAccountLastname() {
        return this.accountLastname;
    }

    public String getAccountFirstname() {
        return this.accountFirstname;
    }

    public String getInstitutionID() {
        return this.institutionID;
    }

    public String getInstitutionName() {
        return this.institutionName;
    }

    public String getFormID() {
        return this.formID;
    }

    public String getFormName() {
        return this.formName;
    }

    @Override
    public int compareTo(MedNetConfigFormItem other) {
        if (other == null) {
            return -1;
        }
        if (this.getAccountID() != null && other.getAccountID() == null) {
            return -1;
        }
        if (this.getAccountID() == null && other.getAccountID() != null) {
            return 1;
        }
        int comparator = this.getAccountID().compareTo(other.getAccountID());
        if (comparator != 0) {
            return comparator;
        }
        if (this.getInstitutionID() != null && other.getInstitutionID() == null) {
            return -1;
        }
        if (this.getInstitutionID() == null && other.getInstitutionID() != null) {
            return 1;
        }
        comparator = this.getInstitutionID().compareTo(other.getInstitutionID());
        if (comparator != 0) {
            return comparator;
        }
        if (this.getFormID() != null && other.getFormID() == null) {
            return -1;
        }
        if (this.getFormID() == null && other.getFormID() != null) {
            return 1;
        }
        return this.getFormID().compareTo(other.getFormID());
    }
}

