/*
 * Decompiled with CFR 0.152.
 */
package ch.medshare.elexis.directories;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Locale;

public class DirectoriesHelper {
    private static String cleanupText(String text) {
        text = text.replaceFirst("(?s)</title>.*<div class='summary'>", "</title>\n\n<!-- Elexis/js: Unwanted multiline content removed during preprocessing - this may have broken the HTML tree structure -->\n\n<div class='summary'>");
        text = text.replaceAll("(?s)<div class='content-box' id='ad-rectangle'>.*", "\n<!-- Elexis/js: Unwanted multiline content removed during preprocessing - this may have broken the HTML tree structure -->\n<!-- Removal of this html portion is, however, needed. Otherwise, parsing might search/skip into that part and last entries could be incompletely returned. -->\n");
        text = text.replaceAll("<div class='ad'.*></div>\n", "");
        text = text.replaceAll("<div data-east='.*></div>\n", "");
        text = text.replace("</nobr>", "").replace("<nobr>", "");
        text = text.replace("&amp;", "&");
        text = text.replace("<b class=\"searchWords\">", "");
        text = text.replace("</b>", "");
        text = text.replace('\u00a0', ' ');
        return text;
    }

    private static String cleanupUmlaute(String text) {
        text = text.replace("&#xE4;", "\u00e4");
        text = text.replace("&#xC4;", "\u00c4");
        text = text.replace("&#xF6;", "\u00f6");
        text = text.replace("&#xD6;", "\u00d6");
        text = text.replace("&#xFC;", "\u00fc");
        text = text.replace("&#xDC;", "\u00dc");
        text = text.replace("&#xE8;", "\u00e8");
        text = text.replace("&#xE9;", "\u00e9");
        text = text.replace("&#xEA;", "\u00ea");
        text = text.replace("&#xE0;", "\u00e0");
        text = text.replace("&#xA0;", " ");
        return text;
    }

    private static URL getURL(String name, String geo) throws MalformedURLException {
        name = name.replace(' ', '+');
        geo = geo.replace(' ', '+');
        String urlPattern = "http://tel.local.ch/{0}/q/?what={1}&where={2}&mode=text";
        System.out.print("jsdebug: DirectoriesHelper.java: " + urlPattern + "\n");
        System.out.print("jsdebug: DirectoriesHelper.java: language: " + Locale.getDefault().getLanguage() + "  name: " + name + "  geo: " + geo + "\n");
        System.out.print("jsToDo:  DirectoriesHelper.java: ToDo: maybe add &range=all to the search request.\n");
        return new URL(MessageFormat.format(urlPattern, Locale.getDefault().getLanguage(), name, geo));
    }

    public static void writeFile(String filenamePath, String text) throws IOException {
        System.out.print("jsdebug: DirectoriesHelper.java writeFile(" + filenamePath + ",text) running...\n");
        try (FileOutputStream output = null;){
            output = new FileOutputStream(filenamePath);
            output.write(text.getBytes());
        }
    }

    public static String readContent(String name, String geo) throws IOException, MalformedURLException {
        StringBuffer sb;
        block15: {
            System.out.print("jsdebug: DirectoriesHelper.java readContent() running...\n");
            String userAgent = "Elexis/js www.jsigle.com/prog/elexis";
            URL URLcontent = DirectoriesHelper.getURL(name, geo);
            URLConnection connection = null;
            InputStream input = null;
            System.out.print("jsdebug: DirectoriesHelper.java userAgent=" + userAgent + "\n");
            System.out.print("jsdebug: DirectoriesHelper.java URLcontent=" + URLcontent.toString() + "\n");
            sb = new StringBuffer();
            try {
                try {
                    connection = URLcontent.openConnection();
                    connection.addRequestProperty("User-Agent", userAgent);
                    input = connection.getInputStream();
                    InputStreamReader isr = new InputStreamReader(input, "UTF-8");
                    int count = 0;
                    char[] c = new char[10000];
                    while ((count = isr.read(c)) > 0) {
                        sb.append(c, 0, count);
                    }
                }
                catch (IOException e) {
                    System.out.print("jsErrorMessage: Error reading: " + URLcontent.toString() + " " + e.toString());
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException e2) {
                            System.out.print("jsErrorMessage: Error closing input stream: " + URLcontent.toString() + " " + e2.toString());
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        System.out.print("jsErrorMessage: Error closing input stream: " + URLcontent.toString() + " " + e.toString());
                    }
                }
                throw throwable;
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    System.out.print("jsErrorMessage: Error closing input stream: " + URLcontent.toString() + " " + e.toString());
                }
            }
        }
        System.out.print("jsToDo: DirectoriesHelper.java Change the above error messages so that they appear in the Elexis logs.");
        System.out.print("\n\n\njsdebug: DirectoriesHelper.java readContent().sb.toString():\n --------(html text begin)--------\n" + sb.toString() + "\njsdebug: --------(html text end)--------\n\n\n\n");
        System.out.print("\n\n\njsdebug: DirectoriesHelper.java cleanup...(readContent().sb.toString()):\n --------(html text begin)--------\n" + DirectoriesHelper.cleanupUmlaute(DirectoriesHelper.cleanupText(sb.toString())) + "\njsdebug: --------(html text end)--------\n\n\n\n");
        return DirectoriesHelper.cleanupUmlaute(DirectoriesHelper.cleanupText(sb.toString()));
    }
}

