/*
 * Decompiled with CFR 0.152.
 */
package ch.medshare.connect.abacusjunior;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.importer.div.rs232.Connection;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.core.ui.util.SWTHelper;
import ch.medshare.connect.abacusjunior.Messages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Preferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static Logger logger = LoggerFactory.getLogger(Preferences.class);
    public static final String ABACUSJUNIOR_BASE = "connectors/abacusjunior/";
    public static final String PORT = "connectors/abacusjunior/port";
    public static final String PARAMS = "connectors/abacusjunior/params";
    public static final String LOG = "connectors/abacusjunior/log";
    Combo ports;
    Text speed;
    Text data;
    Text stop;
    Button parity;
    Button log;

    public Preferences() {
        super(Messages.AbacusJuniorAction_ButtonName);
        this.setPreferenceStore((IPreferenceStore)new SettingsPreferenceStore(CoreHub.localCfg));
    }

    protected Control createContents(Composite parent) {
        logger.debug("Start von createContents");
        String[] param = CoreHub.localCfg.get(PARAMS, "9600,8,n,1").split(",");
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout(2, false));
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        new Label(ret, 0).setText(Messages.Preferences_Port);
        this.ports = new Combo(ret, 4);
        this.ports.setItems(Connection.getComPorts());
        this.ports.setText(CoreHub.localCfg.get(PORT, Messages.AbacusJuniorAction_DefaultPort));
        new Label(ret, 0).setText(Messages.Preferences_Baud);
        this.speed = new Text(ret, 2048);
        this.speed.setText(param[0]);
        new Label(ret, 0).setText(Messages.Preferences_Databits);
        this.data = new Text(ret, 2048);
        this.data.setText(param[1]);
        new Label(ret, 0).setText(Messages.Preferences_Parity);
        this.parity = new Button(ret, 32);
        this.parity.setSelection(!param[2].equalsIgnoreCase("n"));
        new Label(ret, 0).setText(Messages.Preferences_Stopbits);
        this.stop = new Text(ret, 2048);
        this.stop.setText(param[3]);
        new Label(ret, 0).setText(Messages.Preferences_Log);
        this.log = new Button(ret, 32);
        this.log.setSelection(CoreHub.localCfg.get(LOG, "n").equalsIgnoreCase("y"));
        return ret;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.speed.getText()).append(",").append(this.data.getText()).append(",").append(this.parity.getSelection() ? "y" : "n").append(",").append(this.stop.getText());
        CoreHub.localCfg.set(PARAMS, sb.toString());
        CoreHub.localCfg.set(PORT, this.ports.getText());
        CoreHub.localCfg.set(LOG, this.log.getSelection() ? "y" : "n");
        CoreHub.localCfg.flush();
        return super.performOk();
    }
}

