/*
 * Decompiled with CFR 0.152.
 */
package ch.medshare.connect.abacusjunior;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.importer.div.rs232.Connection;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.LabItem;
import ch.elexis.data.Patient;
import ch.medshare.connect.abacusjunior.Logger;
import ch.medshare.connect.abacusjunior.Messages;
import ch.medshare.connect.abacusjunior.packages.DataPackage;
import ch.medshare.connect.abacusjunior.packages.InitPackage;
import java.io.File;
import java.io.FileNotFoundException;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class AbacusJuniorAction
extends Action
implements Connection.ComPortListener {
    Connection _ctrl;
    Patient _actPatient;
    Logger _log;

    public AbacusJuniorAction() {
        super(Messages.AbacusJuniorAction_ButtonName, 2);
        this.setToolTipText(Messages.AbacusJuniorAction_ToolTip);
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"ch.medshare.connect.abacusjunior", (String)"icons/abacusjunior.ico"));
        this._ctrl = new Connection(Messages.AbacusJuniorAction_ConnectionName, CoreHub.localCfg.get("connectors/abacusjunior/port", Messages.AbacusJuniorAction_DefaultPort), CoreHub.localCfg.get("connectors/abacusjunior/params", Messages.AbacusJuniorAction_DefaultParams), (Connection.ComPortListener)this);
        if (CoreHub.localCfg.get("connectors/abacusjunior/log", "n").equalsIgnoreCase("y")) {
            try {
                this._log = new Logger(System.getProperty("user.home") + File.separator + "elexis" + File.separator + "abacusjunior.log");
            }
            catch (FileNotFoundException e) {
                SWTHelper.showError((String)Messages.AbacusJuniorAction_LogError_Title, (String)Messages.AbacusJuniorAction_LogError_Text);
                this._log = new Logger();
            }
        } else {
            this._log = new Logger(false);
        }
    }

    public void run() {
        if (this.isChecked()) {
            KontaktSelektor ksl = new KontaktSelektor(Hub.getActiveShell(), Patient.class, Messages.AbacusJuniorAction_Patient_Title, Messages.AbacusJuniorAction_Patient_Text, Patient.DEFAULT_SORT);
            ksl.create();
            ksl.getShell().setText(Messages.AbacusJuniorAction_Patient_Title);
            if (ksl.open() == 0) {
                this._actPatient = (Patient)ksl.getSelection();
                this._log.logStart();
                if (this._ctrl.connect()) {
                    this._ctrl.awaitFrame(1, 4, 0, 6000);
                    return;
                }
                this._log.log("Error");
                SWTHelper.showError((String)Messages.AbacusJuniorAction_RS232_Error_Title, (String)Messages.AbacusJuniorAction_RS232_Error_Text);
            }
        } else if (this._ctrl.isOpen()) {
            this._actPatient = null;
            this._ctrl.sendBreak();
            this._ctrl.close();
        }
        this.setChecked(false);
        this._log.logEnd();
    }

    public void gotBreak(Connection connection) {
        this._actPatient = null;
        connection.close();
        this.setChecked(false);
        this._log.log("Break");
        this._log.logEnd();
        SWTHelper.showError((String)Messages.AbacusJuniorAction_RS232_Break_Title, (String)Messages.AbacusJuniorAction_RS232_Break_Text);
    }

    public void gotChunk(Connection connection, String data) {
        this._log.logRX(data);
        char id = data.charAt(1);
        char type = data.charAt(2);
        String message = data.substring(data.indexOf(2) + 1, data.indexOf(3));
        switch (type) {
            case 'I': {
                InitPackage initPkg = new InitPackage(id, message);
                this._log.logTX(initPkg.getResponse());
                this._ctrl.send(initPkg.getResponse());
                break;
            }
            case 'D': {
                DataPackage dataPkg = new DataPackage(id, message);
                this._ctrl.send(dataPkg.getResponse());
                this._log.logTX(dataPkg.getResponse());
                if (!dataPkg.getAck()) break;
                dataPkg.fetchResults(this._actPatient);
                this._log.log("Saved");
                this._actPatient = null;
                this._ctrl.close();
                this.setChecked(false);
                ElexisEventDispatcher.reload(LabItem.class);
                this._log.logEnd();
            }
        }
    }

    public void timeout() {
        this._ctrl.close();
        this._log.log("Timeout");
        SWTHelper.showError((String)Messages.AbacusJuniorAction_RS232_Timeout_Title, (String)Messages.AbacusJuniorAction_RS232_Timeout_Text);
        this.setChecked(false);
        this._log.logEnd();
    }
}

