/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.lmz.risch.laborder.net;

import ch.itmed.lmz.risch.laborder.json.ApiRequest;
import ch.itmed.lmz.risch.laborder.json.ApiResponse;
import ch.itmed.lmz.risch.laborder.preferences.PreferenceConstants;
import ch.itmed.lmz.risch.laborder.preferences.SettingsProvider;
import ch.itmed.lmz.risch.laborder.ui.MessageBoxUtil;
import com.google.gson.Gson;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.NoRouteToHostException;
import java.net.URI;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.util.Base64;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpsConnectionHandler {
    private static Logger logger = LoggerFactory.getLogger(HttpsConnectionHandler.class);

    public static void connect(String formId) {
        KeyStore clientStore = null;
        try {
            clientStore = KeyStore.getInstance("PKCS12");
            clientStore.load(new FileInputStream(SettingsProvider.getSettings().getString(PreferenceConstants.CLIENT_CERTIFICATE)), SettingsProvider.getSettings().getString(PreferenceConstants.CERTIFICATE_PASSWORD).toCharArray());
        }
        catch (FileNotFoundException e) {
            MessageBoxUtil.showErrorDialog("Zertifikat nicht gefunden", "Das angegebene Zertifikat konnte nicht ge\u00f6ffnet");
            logger.error("Certificate not found", (Throwable)e);
        }
        catch (IOException e) {
            if (e.getMessage().equals("keystore password was incorrect")) {
                MessageBoxUtil.showErrorDialog("Zertifikat nicht geladen", "Das Zertifikat-Passwort wurde nicht akzeptiert");
            }
            logger.error("Configuration error", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("General error", (Throwable)e);
        }
        try {
            String inputLine;
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(clientStore, SettingsProvider.getSettings().getString(PreferenceConstants.CERTIFICATE_PASSWORD).toCharArray());
            KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
            KeyStore winKeystore = KeyStore.getInstance("Windows-ROOT");
            winKeystore.load(null, null);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(winKeystore);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, new SecureRandom());
            HttpsURLConnection.setDefaultHostnameVerifier((hostname, session) -> true);
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            String riboxAddress = SettingsProvider.getSettings().getString(PreferenceConstants.RIBOX_IP);
            URL url = new URL("https://" + riboxAddress + "/include/moduls/asp.php");
            ApiRequest apiRequest = null;
            try {
                apiRequest = new ApiRequest(formId);
            }
            catch (UnsupportedOperationException e) {
                logger.error("Error creating API request.", (Throwable)e);
                MessageBoxUtil.showErrorDialog("API Request fehlgeschlagen", "Der API Request konnte nicht erstellt werden");
                return;
            }
            Gson gson = new Gson();
            String requestJson = gson.toJson((Object)apiRequest);
            Base64.Encoder encoder = Base64.getEncoder();
            String requestEncode = encoder.encodeToString(requestJson.getBytes());
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)url.openConnection();
            httpsURLConnection.setDoOutput(true);
            httpsURLConnection.setRequestMethod("POST");
            httpsURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpsURLConnection.setRequestProperty("Charset", "UTF-8");
            httpsURLConnection.setRequestProperty("Content-Length", Integer.toString(requestEncode.length()));
            httpsURLConnection.setRequestProperty("Host", riboxAddress);
            httpsURLConnection.setRequestProperty("Connection", "Keep-Alive");
            httpsURLConnection.setUseCaches(false);
            DataOutputStream dataOutputStream = new DataOutputStream(httpsURLConnection.getOutputStream());
            dataOutputStream.writeBytes("APIJson=" + requestEncode);
            dataOutputStream.flush();
            dataOutputStream.close();
            BufferedReader in = new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream()));
            String returnUrl = "";
            while ((inputLine = in.readLine()) != null) {
                Base64.Decoder decoder = Base64.getDecoder();
                byte[] bytesDecoded = decoder.decode(inputLine);
                returnUrl = new String(bytesDecoded);
            }
            in.close();
            ApiResponse apiResponse = (ApiResponse)gson.fromJson(returnUrl, ApiResponse.class);
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(apiResponse.getReturnUrl()));
            }
        }
        catch (UnrecoverableKeyException e) {
            MessageBoxUtil.showErrorDialog("Zertifikat nicht geladen", "Das Zertifikat-Passwort wurde nicht akzeptiert");
            logger.error("Certificate was not accepted", (Throwable)e);
        }
        catch (NoRouteToHostException e) {
            MessageBoxUtil.showErrorDialog("Keine Netzwerkverbindung", "Netzwerkverbindung zum Host konnte nicht hergestellt werden");
            logger.error("No connection to host", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("General error", (Throwable)e);
        }
    }
}

