/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.lmz.risch.laborder.gdt;

import ch.itmed.lmz.risch.laborder.gdt.GdtBody;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GdtEncoder {
    private ByteArrayOutputStream fullGdtFile;
    private static Logger logger = LoggerFactory.getLogger(GdtEncoder.class);

    public GdtEncoder(String formId) throws UnsupportedOperationException {
        try {
            this.fullGdtFile = new ByteArrayOutputStream();
            ByteArrayOutputStream patientData = new ByteArrayOutputStream();
            patientData.write(new GdtBody(formId).toString().getBytes());
            int gdtSize = patientData.size() + 13 + 16;
            String gdtSizeMask = "0000000";
            String gdtSizeString = "0168004" + gdtSizeMask.substring(0, gdtSizeMask.length() - Integer.toString(gdtSize).length()) + Integer.toString(gdtSize) + "\r\n";
            this.fullGdtFile.write("01380006301\r\n".getBytes());
            this.fullGdtFile.write(gdtSizeString.getBytes());
            patientData.writeTo(this.fullGdtFile);
        }
        catch (IOException e) {
            logger.error("Error creating GDT file", (Throwable)e);
        }
    }

    public String toString() {
        Base64.Encoder encoder = Base64.getEncoder();
        byte[] encoded = encoder.encode(this.fullGdtFile.toByteArray());
        return new String(encoded);
    }
}

