/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.fop.printing.data;

import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.agenda.AreaType;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.itmed.fop.printing.data.Salutation;
import ch.rgw.tools.TimeTool;
import java.util.Comparator;
import java.util.List;

public final class AppointmentData {
    private IAppointment appointment;

    public void load(List<IAppointment> appointments) throws NullPointerException {
        if (appointments == null || appointments.isEmpty()) {
            this.appointment = ContextServiceHolder.get().getTyped(IAppointment.class).orElse(null);
            if (this.appointment == null) {
                throw new NullPointerException("No appointment selected");
            }
        } else {
            this.appointment = appointments.get(0);
        }
    }

    public AppointmentData() {
    }

    public AppointmentData(IAppointment appointment) {
        this.appointment = appointment;
    }

    public String getAppointmentDetailed() {
        StringBuilder appointmentDate = new StringBuilder();
        TimeTool startTime = this.getStartTime();
        appointmentDate.append(startTime.toString(12));
        appointmentDate.append(", ");
        appointmentDate.append(startTime.toString(4));
        appointmentDate.append(" ");
        appointmentDate.append(startTime.toString(3));
        if (!this.appointment.isAllDay()) {
            appointmentDate.append(" - ");
            TimeTool endTime = new TimeTool(this.appointment.getEndTime());
            appointmentDate.append(endTime.toString(3));
        }
        return appointmentDate.toString();
    }

    public String getAppointmentDetailedNoEnd() {
        StringBuilder appointmentDate = new StringBuilder();
        TimeTool startTime = this.getStartTime();
        appointmentDate.append(startTime.toString(12));
        appointmentDate.append(", ");
        appointmentDate.append(startTime.toString(4));
        appointmentDate.append(" ");
        appointmentDate.append(startTime.toString(3));
        return appointmentDate.toString();
    }

    public TimeTool getEndTime() {
        return new TimeTool(this.appointment.getEndTime());
    }

    public TimeTool getStartTime() {
        return new TimeTool(this.appointment.getStartTime());
    }

    public String getEarliestAndLatestAppointmentTimes(List<IAppointment> allRelatedAppointments) {
        if (allRelatedAppointments == null || allRelatedAppointments.isEmpty()) {
            return this.getAppointmentDetailed();
        }
        IAppointment earliestAppointment = allRelatedAppointments.stream().min(Comparator.comparing(appointment -> new TimeTool(appointment.getStartTime()))).orElse(this.appointment);
        IAppointment latestAppointment = allRelatedAppointments.stream().max(Comparator.comparing(appointment -> new TimeTool(appointment.getEndTime()))).orElse(this.appointment);
        TimeTool earliestStartTime = new TimeTool(earliestAppointment.getStartTime());
        TimeTool latestEndTime = new TimeTool(latestAppointment.getEndTime());
        String formattedWeekday = earliestStartTime.toString(12);
        String formattedEarliestDate = earliestStartTime.toString(4);
        String formattedEarliestTime = earliestStartTime.toString(3);
        String formattedLatestTime = latestEndTime.toString(3);
        if (earliestStartTime.isSameDay(latestEndTime)) {
            return formattedWeekday + ", " + formattedEarliestDate + " " + formattedEarliestTime + " - " + formattedLatestTime;
        }
        String formattedLatestDate = latestEndTime.toString(4);
        return formattedWeekday + ", " + formattedEarliestDate + " " + formattedEarliestTime + " - " + formattedLatestDate + " " + formattedLatestTime;
    }

    public String getAgendaArea() {
        IContact contact = null;
        String agendaSection = this.appointment.getSchedule();
        String type = ConfigServiceHolder.getGlobal((String)("agenda/bereich/" + agendaSection + "/type"), null);
        if (type != null && type.startsWith(AreaType.CONTACT.name())) {
            contact = CoreModelServiceHolder.get().load(type.substring(AreaType.CONTACT.name().length() + 1), IContact.class).orElse(null);
        }
        if (contact != null) {
            return Salutation.getSalutation(contact);
        }
        return agendaSection;
    }

    public IAppointment getAppointment() {
        return this.appointment;
    }
}

