/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.fop.printing.xml.documents;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FoTransformer {
    private static Logger logger = LoggerFactory.getLogger(FoTransformer.class);
    public static String DEBUG_MODE = "fop.printing.debug";

    public static InputStream transformXmlToFo(InputStream xmlInputStream, File xslFile) throws Exception {
        if (!xslFile.exists()) {
            logger.error("XSL template " + xslFile.getAbsolutePath() + " not found");
            throw new IllegalStateException("Druck fehlgeschlagen. Die Vorlage " + xslFile.toString() + " konnte nicht gefunden werden.");
        }
        if (xmlInputStream == null) {
            logger.error("Failed to create XML file");
            return null;
        }
        if (System.getProperty(DEBUG_MODE) != null) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)xmlInputStream, (OutputStream)bo);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StreamResult result = new StreamResult(new StringWriter());
            StreamSource source = new StreamSource(new ByteArrayInputStream(bo.toByteArray()));
            transformer.transform(source, result);
            System.out.println(result.getWriter().toString());
            xmlInputStream = new ByteArrayInputStream(bo.toByteArray());
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(new StreamSource(xslFile));
        StreamSource src = new StreamSource(xmlInputStream);
        StreamResult res = new StreamResult(out);
        transformer.transform(src, res);
        return new ByteArrayInputStream(out.toByteArray());
    }
}

