/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.fop.printing.xml.elements;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPatient;
import ch.itmed.fop.printing.barcode.BarcodeCreator;
import ch.itmed.fop.printing.data.PatientData;
import ch.itmed.fop.printing.preferences.PreferenceConstants;
import ch.itmed.fop.printing.preferences.Setting;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BarCodeElement {
    public static Element create(Document doc, boolean loadFromAgenda) throws Exception {
        return BarCodeElement.create(doc, loadFromAgenda, false, null);
    }

    public static Element create(Document doc, boolean loadFromAgenda, boolean useLegalGuardian, IPatient patient) throws Exception {
        PatientData pd = new PatientData(useLegalGuardian);
        if (loadFromAgenda) {
            pd.loadFromAgenda();
        } else {
            pd.load(patient);
        }
        String docName = "BarCodeLabel";
        int barcodeFormat = Integer.parseInt(Setting.getString(docName, PreferenceConstants.getDocPreferenceConstant(docName, 14)));
        boolean isBarcodeFormat1 = barcodeFormat == 14;
        Element p = doc.createElement("Etikette");
        if (isBarcodeFormat1) {
            p.setAttribute("barcodeLabel", BarcodeCreator.createInternalCode128FromKontaktPatNr((IContact)pd.getPatient()));
        } else {
            p.setAttribute("barcodeLabel", BarcodeCreator.createInternalCode128fromKontakt((IContact)pd.getPatient()));
        }
        return p;
    }
}

