/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.fop.printing.data;

import ch.elexis.core.model.IContact;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.itmed.fop.printing.data.Salutation;

public class ContactData {
    private IContact kontakt;

    public void load() throws NullPointerException {
        this.kontakt = ContextServiceHolder.get().getTyped(IContact.class).orElse(null);
        if (this.kontakt == null) {
            throw new NullPointerException("No contact selected");
        }
    }

    public String getAddress() {
        return this.getAddress(false);
    }

    public String getAddress(boolean useLegalGuardian) {
        if (this.kontakt != null) {
            IContact legalGuardian = this.getLegalGuardian();
            if (legalGuardian != null) {
                return legalGuardian.getPostalAddress();
            }
            return this.kontakt.getPostalAddress();
        }
        return "";
    }

    private IContact getLegalGuardian() {
        if (this.kontakt.isPerson()) {
            return this.kontakt.asIPerson().getLegalGuardian();
        }
        return null;
    }

    public String getSalutaton() {
        if (this.kontakt != null) {
            return Salutation.getSalutation(this.kontakt);
        }
        return "";
    }
}

