/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.fop.printing.xml.elements;

import ch.elexis.agenda.util.AppointmentExtensionHandler;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IPatient;
import ch.itmed.fop.printing.data.AppointmentData;
import ch.itmed.fop.printing.data.AppointmentsData;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AppointmentsInformationElement {
    public static Element create(Document doc, boolean singleAppoinment) throws Exception {
        return AppointmentsInformationElement.create(doc, singleAppoinment, Collections.emptyList(), null);
    }

    public static Element create(Document doc, boolean singleAppoinment, List<IAppointment> appointments, IPatient patient) throws Exception {
        List<AppointmentData> al;
        if (singleAppoinment) {
            ad = new AppointmentData();
            ((AppointmentData)ad).load(appointments);
            al = new ArrayList<AppointmentData>();
            al.add((AppointmentData)ad);
        } else {
            ad = new AppointmentsData();
            al = ((AppointmentsData)ad).load(appointments, patient);
        }
        Element p = doc.createElement("AppointmentsInformation");
        if (!al.isEmpty()) {
            Element l = doc.createElement("AppointmentsList");
            if (!al.isEmpty()) {
                Collections.sort(al, new Comparator<AppointmentData>(){

                    @Override
                    public int compare(AppointmentData o1, AppointmentData o2) {
                        return o1.getStartTime().compareTo((Calendar)o2.getStartTime());
                    }
                });
                for (AppointmentData ad : al) {
                    Element element = doc.createElement("ListAppointment");
                    element.setAttribute("area", ad.getAgendaArea());
                    element.appendChild(doc.createTextNode(ad.getAppointmentDetailed()));
                    l.appendChild(element);
                    Element appointmentNoEnd = doc.createElement("ListAppointmentNoEnd");
                    appointmentNoEnd.setAttribute("area", ad.getAgendaArea());
                    appointmentNoEnd.appendChild(doc.createTextNode(ad.getAppointmentDetailedNoEnd()));
                    l.appendChild(appointmentNoEnd);
                }
            }
            p.appendChild(l);
            Map<String, List<AppointmentData>> appointmentPerAreaMap = al.stream().collect(Collectors.groupingBy(AppointmentData::getAgendaArea));
            ArrayList<Map.Entry<String, List<AppointmentData>>> appointmentPerArea = new ArrayList<Map.Entry<String, List<AppointmentData>>>(appointmentPerAreaMap.entrySet());
            appointmentPerArea.sort(new Comparator<Map.Entry<String, List<AppointmentData>>>(){

                @Override
                public int compare(Map.Entry<String, List<AppointmentData>> e1, Map.Entry<String, List<AppointmentData>> e2) {
                    return e1.getValue().get(0).getStartTime().compareTo((Calendar)e2.getValue().get(0).getStartTime());
                }
            });
            for (Map.Entry entry : appointmentPerArea) {
                List areaAppointments = (List)entry.getValue();
                Element c = doc.createElement("AgendaArea");
                c.appendChild(doc.createTextNode((String)entry.getKey()));
                p.appendChild(c);
                c = doc.createElement("Appointments");
                for (AppointmentData ad : areaAppointments) {
                    List allRelatedAppointments = AppointmentExtensionHandler.getAllRelatedAppointments((IAppointment)ad.getAppointment());
                    String appointmentDetails = ad.getEarliestAndLatestAppointmentTimes(allRelatedAppointments);
                    Element appointment = doc.createElement("Appointment");
                    appointment.appendChild(doc.createTextNode(appointmentDetails));
                    c.appendChild(appointment);
                    Element appointmentNoEnd = doc.createElement("AppointmentNoEnd");
                    appointmentNoEnd.appendChild(doc.createTextNode(ad.getAppointmentDetailedNoEnd()));
                    c.appendChild(appointmentNoEnd);
                }
                p.appendChild(c);
            }
        }
        return p;
    }
}

